/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.combridge;

import edu.mit.lcs.haystack.HaystackException;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IDereferenceable;
import edu.mit.lcs.haystack.adenine.interpreter.InvalidMemberException;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import org.eclipse.swt.ole.win32.HaystackHooks;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class DispatchDriver
implements IDereferenceable {
    OleAutomation m_oleAutomation;
    protected ICallable m_disposeMember = new ICallable(){

        public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
            DispatchDriver.this.m_oleAutomation.dispose();
            return new Message();
        }
    };

    DispatchDriver(OleAutomation oleAutomation) {
        this.m_oleAutomation = oleAutomation;
    }

    public DispatchDriver(String strCLSID) throws AdenineException {
        try {
            this.m_oleAutomation = HaystackHooks.createOleAutomation((String)strCLSID);
        }
        catch (HaystackException he) {
            throw new AdenineException("COM error", he);
        }
    }

    public Object getMember(Object member) throws AdenineException {
        if (member.equals("_dispose")) {
            return this.m_disposeMember;
        }
        if (member instanceof String) {
            String name = (String)member;
            boolean get = false;
            boolean put = false;
            if (name.startsWith("get_")) {
                name = name.substring(4);
                get = true;
            } else if (name.startsWith("put_")) {
                name = name.substring(4);
                put = true;
            }
            int[] ids = this.m_oleAutomation.getIDsOfNames(new String[]{name});
            if (ids == null) {
                throw new InvalidMemberException(member);
            }
            return new MethodDriver(ids[0], get, put);
        }
        throw new InvalidMemberException(member);
    }

    class MethodDriver
    implements ICallable {
        int m_dispid;
        boolean m_put;
        boolean m_get;

        MethodDriver(int dispid, boolean get, boolean put) {
            this.m_dispid = dispid;
            this.m_get = get;
            this.m_put = put;
        }

        public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
            Variant[] args = new Variant[message.m_values.length];
            int i = 0;
            while (i < message.m_values.length) {
                Object o = message.m_values[i];
                if (o == null) {
                    args[i] = new Variant();
                } else if (o instanceof Integer) {
                    args[i] = new Variant(((Integer)o).intValue());
                } else if (o instanceof Float) {
                    args[i] = new Variant(((Float)o).floatValue());
                } else if (o instanceof Variant) {
                    args[i] = (Variant)o;
                } else if (o instanceof Short) {
                    args[i] = new Variant(((Short)o).shortValue());
                } else if (o instanceof Boolean) {
                    args[i] = new Variant(((Boolean)o).booleanValue());
                } else if (o instanceof String) {
                    args[i] = new Variant((String)o);
                } else if (o instanceof DispatchDriver) {
                    args[i] = new Variant(((DispatchDriver)o).m_oleAutomation);
                } else {
                    throw new AdenineException("Parameter " + i + " is not marshalable");
                }
                ++i;
            }
            Variant out = null;
            if (this.m_put) {
                DispatchDriver.this.m_oleAutomation.setProperty(this.m_dispid, args);
            } else {
                out = this.m_get ? DispatchDriver.this.m_oleAutomation.getProperty(this.m_dispid, args) : DispatchDriver.this.m_oleAutomation.invoke(this.m_dispid, args);
            }
            if (out == null) {
                return new Message();
            }
            switch (out.getType() & 0xFFFFBFFF) {
                case 2: {
                    return new Message(new Short(out.getShort()));
                }
                case 4: {
                    return new Message(new Float(out.getFloat()));
                }
                case 3: {
                    return new Message(new Integer(out.getInt()));
                }
                case 11: {
                    return new Message(new Boolean(out.getBoolean()));
                }
                case 8: {
                    return new Message(out.getString());
                }
                case 9: {
                    return new Message(new DispatchDriver(out.getAutomation()));
                }
                case 1: {
                    return new Message();
                }
            }
            return new Message(out);
        }
    }
}

