/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.HaystackException;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class AdenineException
extends HaystackException {
    public int m_line = -1;
    public ArrayList m_stackTrace = new ArrayList();

    public AdenineException(String str) {
        super(str);
    }

    public AdenineException(String str, Throwable e) {
        super(str, e);
    }

    public AdenineException(String str, int line) {
        super(str);
        this.m_line = line;
    }

    public AdenineException(String str, Throwable e, int line) {
        super(str, e);
        this.m_line = line;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getMessage());
        if (this.m_line != -1) {
            sb.append(" occurred at line ");
            sb.append(this.m_line);
            sb.append(": ");
        }
        sb.append("\n");
        Iterator i = this.m_stackTrace.iterator();
        while (i.hasNext()) {
            sb.append("\t");
            sb.append((String)i.next());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addToStackTrace(String operation, int line) {
        this.m_stackTrace.add(String.valueOf(operation) + " at line " + line);
    }

    public void addToStackTrace(Resource resFunction) {
        this.m_stackTrace.add("in method " + resFunction);
    }

    public static String describeInstruction(Resource resInstruction, IRDFContainer rdfc) {
        RDFNode operation = Utilities.getIndirectProperty(resInstruction, Constants.s_rdf_type, Constants.s_rdfs_label, rdfc);
        StringBuffer sb = new StringBuffer();
        if (operation != null && operation instanceof Literal) {
            sb.append(operation.getContent());
        } else {
            sb.append("Unknown operation");
        }
        sb.append(" at ");
        String strLine = Utilities.getLiteralProperty(resInstruction, AdenineConstants.line, rdfc);
        if (strLine == null) {
            sb.append("unknown line");
        } else {
            sb.append("line ");
            sb.append(strLine);
        }
        return sb.toString();
    }

    public void addToStackTrace(Resource resInstruction, IRDFContainer rdfc) {
        this.m_stackTrace.add(AdenineException.describeInstruction(resInstruction, rdfc));
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    protected void printStackTrace0(PrintStream ps) {
        if (this.chain instanceof AdenineException) {
            ((AdenineException)this.chain).printStackTrace0(ps);
        } else if (this.chain != null) {
            ps.print("Java exception: ");
            this.chain.printStackTrace(ps);
        }
        ps.println(this.getMessage());
    }

    protected void printStackTrace0(PrintWriter ps) {
        if (this.chain instanceof AdenineException) {
            ((AdenineException)this.chain).printStackTrace0(ps);
        } else if (this.chain != null) {
            ps.print("Java exception: ");
            this.chain.printStackTrace(ps);
        }
        ps.println(this.getMessage());
    }

    public void printStackTrace(PrintWriter s) {
        s.println("An Adenine exception has occurred.");
        this.printStackTrace0(s);
    }

    public void printStackTrace(PrintStream s) {
        s.println("An Adenine exception has occurred.");
        this.printStackTrace0(s);
    }
}

