/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.Console;
import edu.mit.lcs.haystack.adenine.SWTConsole;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.RDFCodeCompiler;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.ozone.Ozone;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.security.Identity;
import edu.mit.lcs.haystack.security.IdentityManager;
import edu.mit.lcs.haystack.server.service.ServiceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sun.security.tools.KeyTool;

public class Haystack {
    public static Logger s_logger;
    private File m_baseSystemPath;
    private File m_baseUserPath;
    private File m_identityFile;
    private File m_keyFile;
    private Resource m_userResource;
    public IdentityManager m_identityManager;
    public ServiceManager m_serviceManager;
    public Identity m_userIdentity;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.Haystack;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public Haystack(boolean startNow) {
        if (startNow) {
            this.start();
        }
    }

    public Haystack() {
        this(true);
    }

    public void start() {
        try {
            Resource baseRes;
            s_logger.info((Object)"Starting Haystack");
            this.initializePaths();
            this.initializeKeys();
            this.m_identityManager = new IdentityManager(this.m_keyFile.toString());
            if (!this.m_identityManager.containsIdentity(this.m_userResource)) {
                s_logger.error((Object)"haystack-keys file does not contain user's keys");
                return;
            }
            this.m_userIdentity = this.m_identityManager.authenticate(this.m_userResource, "haystack");
            String localRDF = System.getProperty("edu.mit.lcs.haystack.bootstrap", this.m_baseUserPath + File.separatorChar + "bootstrap.rdf");
            File bootstrap = new File(localRDF);
            if (!bootstrap.exists()) {
                this.createBootstrapRDF(bootstrap);
            } else {
                s_logger.info((Object)("found bootstrap file: " + bootstrap));
            }
            String basePath = String.valueOf(this.m_baseUserPath.toString()) + File.separatorChar;
            LocalRDFContainer source = new LocalRDFContainer();
            try {
                Utilities.parseRDF(new URL("file", "", localRDF.replace(File.separatorChar, '/')), (IRDFContainer)source);
            }
            catch (Exception e) {
                s_logger.error((Object)("An error occurred reading local RDF file " + localRDF), (Throwable)e);
                throw new RuntimeException();
            }
            try {
                baseRes = (Resource)source.extract(null, Constants.s_rdf_type, Constants.s_config_HaystackServer);
            }
            catch (Exception e) {
                s_logger.error((Object)("Bootstrap file " + localRDF + " missing config:HaystackServer reference"), (Throwable)e);
                throw new RuntimeException();
            }
            if (System.getProperty("edu.mit.lcs.haystack.hostname", "").length() == 0) {
                String hostname = "localhost";
                try {
                    hostname = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.setProperty("edu.mit.lcs.haystack.hostname", hostname);
            }
            this.m_serviceManager = new ServiceManager(basePath, (IRDFContainer)source, baseRes, this.m_identityManager);
            try {
                this.m_serviceManager.start();
            }
            catch (Exception e) {
                s_logger.error((Object)("An error occurred starting the service manager with bootstrap file " + localRDF + "."), (Throwable)e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Haystack.this.m_serviceManager.stop();
                    }
                    catch (Exception e) {
                        s_logger.error((Object)"An error occurred while shutting down the system", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            s_logger.error((Object)"System error", (Throwable)e);
        }
    }

    public IRDFContainer getRootRDFContainer() {
        return this.m_serviceManager.getRootRDFContainer();
    }

    public static void main(String[] args) {
        Haystack haystack = new Haystack();
        try {
            Display display = Display.getDefault();
            Shell s = new Shell();
            s.setText("Adenine Console");
            s.setLayout((Layout)new FillLayout());
            SWTConsole c = new SWTConsole((Composite)s, haystack.m_serviceManager.getRootRDFContainer());
            c.setEnvironmentValue("__identity__", haystack.m_userIdentity);
            c.setEnvironmentValue("__infosource__", Ozone.getInformationSource((IRDFContainer)haystack.m_serviceManager.getRootRDFContainer(), (Identity)haystack.m_userIdentity, (IServiceAccessor)haystack.m_serviceManager));
            c.setServiceAccessor((IServiceAccessor)haystack.m_serviceManager);
            s.open();
            while (!s.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
            System.exit(0);
        }
        catch (Exception e) {
            new Console(haystack.m_serviceManager.getRootRDFContainer()).run();
            System.exit(0);
        }
    }

    private void initializePaths() {
        String userString;
        String baseString = System.getProperty("edu.mit.lcs.haystack.basepath", new File(".").getAbsolutePath());
        System.setProperty("edu.mit.lcs.haystack.basepath", baseString);
        this.m_baseSystemPath = new File(baseString);
        if (!(this.m_baseSystemPath.exists() || this.m_baseSystemPath.mkdirs() || this.m_baseSystemPath.canWrite())) {
            s_logger.error((Object)("Couldn't access base directory " + this.m_baseSystemPath));
            System.exit(-1);
        }
        if ((userString = System.getProperty("edu.mit.lcs.haystack.userpath")) == null) {
            userString = System.getProperty("os.name").equals("Mac OS X") ? String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/Haystack" : this.m_baseSystemPath.toString();
        }
        System.setProperty("edu.mit.lcs.haystack.userpath", userString);
        this.m_baseUserPath = new File(userString);
        if (!(this.m_baseUserPath.exists() || this.m_baseUserPath.mkdirs() || this.m_baseUserPath.canWrite())) {
            s_logger.error((Object)("Couldn't access user directory " + this.m_baseUserPath));
            throw new RuntimeException();
        }
        File precompile = new File(this.m_baseUserPath, "precompile");
        if (!(precompile.exists() || precompile.mkdirs() || precompile.canWrite())) {
            s_logger.error((Object)("Couldn't access adenine precompile directory " + this.m_baseUserPath));
            throw new RuntimeException();
        }
        System.setProperty("edu.mit.lcs.haystack.precompile", precompile.getAbsolutePath());
        s_logger.info((Object)("Set up base path: " + this.m_baseSystemPath.toString()));
        s_logger.info((Object)("Set up user path: " + this.m_baseUserPath.toString()));
        s_logger.info((Object)("Set up precompile path: " + precompile.toString()));
    }

    private Resource initializeKeys() {
        this.m_identityFile = new File(this.m_baseUserPath, "haystack-userid");
        this.m_keyFile = new File(this.m_baseUserPath, "haystack-keys");
        boolean rebuildKeys = false;
        try {
            if (!this.m_identityFile.exists()) {
                this.m_userResource = Utilities.generateUniqueResource();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.m_identityFile)));
                bw.write(this.m_userResource.getURI());
                bw.close();
                s_logger.info((Object)("Created new user id: " + this.m_userResource));
                rebuildKeys = true;
            } else {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.m_identityFile)));
                this.m_userResource = new Resource(br.readLine());
                br.close();
                s_logger.info((Object)("Found user id: " + this.m_userResource));
            }
        }
        catch (IOException e) {
            s_logger.error((Object)("Couldn't access user file " + this.m_identityFile), (Throwable)e);
            throw new RuntimeException();
        }
        if (rebuildKeys || !this.m_keyFile.exists()) {
            s_logger.info((Object)("Creating user keys at: " + this.m_keyFile.toString()));
            String[] keyargs = new String[]{"-genkey", "-alias", this.m_userResource.getURI(), "-keypass", "haystack", "-keystore", this.m_keyFile.toString(), "-dname", "CN=Someone, OU=Haystack, O=Haystack, L=Somewhere, ST=Somewhere, C=US", "-storepass", "haystack"};
            KeyTool.main((String[])keyargs);
        }
        return this.m_userResource;
    }

    private void createBootstrapRDF(File bootstrap) {
        String boot;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.Haystack;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((boot = System.getProperty("edu.mit.lcs.haystack.bootstrapTemplate", clazz.getResource("/bootstrap/bootstrap.ad").toString())).startsWith("/")) {
            boot = "file:" + boot;
        }
        try {
            LocalRDFContainer rdfc2;
            URL template = new URL(boot);
            s_logger.info((Object)("Trying to make bootstrap RDF at: " + bootstrap));
            s_logger.info((Object)("Using template: " + template));
            LocalRDFContainer rdfc = new LocalRDFContainer();
            Resource pakkage = Utilities.generateUniqueResource();
            RDFCodeCompiler compiler = new RDFCodeCompiler(rdfc);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[Ledu.mit.lcs.haystack.Haystack;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            compiler.compile(pakkage, new InputStreamReader(clazz2.getResourceAsStream("/schemata/adenine.ad")), "/schemata/adenine.ad", null, null);
            List errors = compiler.compile(pakkage, new InputStreamReader(template.openStream()), null, null, null);
            if (errors.isEmpty()) {
                rdfc2 = new LocalRDFContainer();
                Resource main = Utilities.getResourceProperty(pakkage, AdenineConstants.main, rdfc);
                if (main != null) {
                    Interpreter i = new Interpreter(rdfc);
                    DynamicEnvironment denv = new DynamicEnvironment();
                    denv.setTarget(rdfc2);
                    denv.setIdentity(this.m_userIdentity);
                    i.callMethod(main, new Object[0], denv);
                }
            } else {
                throw (Exception)errors.get(0);
            }
            BufferedWriter w = new BufferedWriter(new FileWriter(bootstrap));
            w.write(Utilities.generateRDF(rdfc2));
            ((Writer)w).close();
        }
        catch (Exception e) {
            s_logger.error((Object)("Couldn't create bootstrap file " + bootstrap), (Throwable)e);
            throw new RuntimeException();
        }
    }
}

