/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestDAMLProperty
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLProperty("TestDAMLProperty");
    }

    public TestDAMLProperty(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLProperty.unique"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                1.assertFalse((String)"unique", (boolean)p.isUnique());
                p.setIsUnique(true);
                1.assertTrue((String)"unique", (boolean)p.isUnique());
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_domain"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals((String)"prop_domain property", (Object)DAML_OIL.domain, (Object)p.prop_domain().getProperty());
                2.assertEquals((String)"domain cardinality", (int)0, (int)p.prop_domain().count());
                p.prop_domain().add((RDFNode)B);
                2.assertEquals((String)"domain cardinality", (int)1, (int)p.prop_domain().count());
                p.prop_domain().add((RDFNode)C);
                2.assertEquals((String)"domain cardinality", (int)2, (int)p.prop_domain().count());
                this.iteratorTest((Iterator)p.prop_domain().getAll(), new Object[]{B, C});
                p.prop_domain().remove((RDFNode)C);
                2.assertEquals((String)"domain cardinality", (int)1, (int)p.prop_domain().count());
                this.iteratorTest((Iterator)p.prop_domain().getAll(), new Object[]{B});
                2.assertTrue((String)"hasValue", (boolean)p.prop_domain().hasValue((RDFNode)B));
                2.assertTrue((String)"hasValue", (!p.prop_domain().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_range"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals((String)"prop_range property", (Object)DAML_OIL.range, (Object)p.prop_range().getProperty());
                3.assertEquals((String)"range cardinality", (int)0, (int)p.prop_range().count());
                p.prop_range().add((RDFNode)B);
                3.assertEquals((String)"range cardinality", (int)1, (int)p.prop_range().count());
                p.prop_range().add((RDFNode)C);
                3.assertEquals((String)"range cardinality", (int)2, (int)p.prop_range().count());
                this.iteratorTest((Iterator)p.prop_range().getAll(), new Object[]{B, C});
                p.prop_range().remove((RDFNode)C);
                3.assertEquals((String)"range cardinality", (int)1, (int)p.prop_range().count());
                this.iteratorTest((Iterator)p.prop_range().getAll(), new Object[]{B});
                3.assertTrue((String)"hasValue", (boolean)p.prop_range().hasValue((RDFNode)B));
                3.assertTrue((String)"hasValue", (!p.prop_range().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_subPropertyOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                4.assertEquals((String)"prop_subPropertyOf property", (Object)DAML_OIL.subPropertyOf, (Object)p.prop_subPropertyOf().getProperty());
                4.assertEquals((String)"subPropertyOf cardinality", (int)0, (int)p.prop_subPropertyOf().count());
                p.prop_subPropertyOf().add((RDFNode)q);
                4.assertEquals((String)"subPropertyOf cardinality", (int)1, (int)p.prop_subPropertyOf().count());
                p.prop_subPropertyOf().add((RDFNode)r);
                4.assertEquals((String)"subPropertyOf cardinality", (int)2, (int)p.prop_subPropertyOf().count());
                this.iteratorTest((Iterator)p.prop_subPropertyOf().getAll(), new Object[]{q, r});
                p.prop_subPropertyOf().remove((RDFNode)r);
                4.assertEquals((String)"subPropertyOf cardinality", (int)1, (int)p.prop_subPropertyOf().count());
                this.iteratorTest((Iterator)p.prop_subPropertyOf().getAll(), new Object[]{q});
                4.assertTrue((String)"hasValue", (boolean)p.prop_subPropertyOf().hasValue((RDFNode)q));
                4.assertTrue((String)"hasValue", (!p.prop_subPropertyOf().hasValue((RDFNode)r) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSubProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                r.prop_subPropertyOf().add((RDFNode)q);
                q.prop_subPropertyOf().add((RDFNode)p);
                5.assertEquals((String)"subPropertyOf p", (Object)q, (Object)p.getSubProperty());
                this.iteratorTest((Iterator)p.getSubProperties(), new Object[]{q});
                this.iteratorTest((Iterator)p.getSubProperties(false), new Object[]{q});
                this.iteratorTest((Iterator)p.getSubProperties(true), new Object[]{q});
                r.prop_subPropertyOf().add((RDFNode)p);
                this.iteratorTest((Iterator)p.getSubProperties(), new Object[]{q, r});
                this.iteratorTest((Iterator)p.getSubProperties(false), new Object[]{q});
                this.iteratorTest((Iterator)p.getSubProperties(true), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSuperProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_subPropertyOf().add((RDFNode)q);
                q.prop_subPropertyOf().add((RDFNode)r);
                6.assertEquals((String)"superPropertyOf p", (Object)q, (Object)p.getSuperProperty());
                this.iteratorTest((Iterator)p.getSuperProperties(), new Object[]{q});
                this.iteratorTest((Iterator)p.getSuperProperties(false), new Object[]{q});
                this.iteratorTest((Iterator)p.getSuperProperties(true), new Object[]{q});
                p.prop_subPropertyOf().add((RDFNode)r);
                this.iteratorTest((Iterator)p.getSuperProperties(), new Object[]{q, r});
                this.iteratorTest((Iterator)p.getSuperProperties(false), new Object[]{q});
                this.iteratorTest((Iterator)p.getSuperProperties(true), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSameProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLProperty p = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty q = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty r = m.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_samePropertyAs().add((RDFNode)q);
                q.prop_samePropertyAs().add((RDFNode)r);
                this.iteratorTest((Iterator)p.getSameProperties(), new Object[]{q});
                p.prop_samePropertyAs().add((RDFNode)r);
                this.iteratorTest((Iterator)p.getSameProperties(), new Object[]{q, r});
            }
        }, new DAMLTestBase.OntTestCase("Datatype property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLDatatypeProperty p = m.createDAMLDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
                8.assertNotNull((Object)p);
            }
        }, new DAMLTestBase.OntTestCase("unambiguous property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                9.assertFalse((String)"p not unambiguous", (boolean)p.isUnambiguous());
                p.setIsUnambiguous(true);
                9.assertTrue((String)"p not unambiguous", (boolean)p.isUnambiguous());
                p.setIsUnambiguous(false);
                9.assertFalse((String)"p not unambiguous", (boolean)p.isUnambiguous());
            }
        }, new DAMLTestBase.OntTestCase("Transitive property"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                10.assertFalse((String)"p not Transitive", (boolean)p.isTransitive());
                p.setIsTransitive(true);
                10.assertTrue((String)"p not Transitive", (boolean)p.isTransitive());
                p.setIsTransitive(false);
                10.assertFalse((String)"p not Transitive", (boolean)p.isTransitive());
            }
        }, new DAMLTestBase.OntTestCase("DAMLObjectProperty.prop_inverseOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty q = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                p.prop_inverseOf().add((RDFNode)q);
                11.assertEquals((String)"inverse", (Object)q, (Object)p.prop_inverseOf().get());
            }
        }};
    }
}

