/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.soap.axis;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.tulsoft.shared.GException;
import org.tulsoft.tools.soap.SOAPToolkit;

public class SOAPToolkitAxis
implements SOAPToolkit {
    private String wsdl = null;

    public String getServiceName() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return System.getProperty("service.name");
        }
        return ctx.getTargetService();
    }

    public String[] getAttributeNames() {
        MessageContext ctx = MessageContext.getCurrentContext();
        Vector<String> v = new Vector<String>();
        if (ctx == null) {
            Properties props = System.getProperties();
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                v.addElement((String)en.nextElement());
            }
        } else {
            Enumeration en = ctx.getAxisEngine().getOptions().keys();
            while (en.hasMoreElements()) {
                v.addElement((String)en.nextElement());
            }
            en = ctx.getService().getOptions().keys();
            while (en.hasMoreElements()) {
                v.addElement((String)en.nextElement());
            }
        }
        Object[] results = new String[v.size()];
        v.copyInto(results);
        return results;
    }

    public String getAttribute(String name) {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return System.getProperty(name);
        }
        Object value = ctx.getService().getOption(name);
        if (value == null) {
            value = ctx.getAxisEngine().getOption(name);
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Enumeration getSessionAttributeNames() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        HttpServletRequest req = (HttpServletRequest)ctx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        return req.getSession().getAttributeNames();
    }

    public Object getSessionAttribute(String name) {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getSession().get(name);
    }

    public String getSessionId() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        HttpServletRequest req = (HttpServletRequest)ctx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        return req.getSession().getId();
    }

    public URL getServiceURL(String serviceName) throws GException {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        HttpServletRequest req = (HttpServletRequest)ctx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String url = new String(req.getRequestURL());
        int pos = url.lastIndexOf("/");
        try {
            if (pos > -1) {
                return new URL(url.substring(0, pos + 1) + serviceName);
            }
            return new URL(url + "/" + serviceName);
        }
        catch (MalformedURLException e) {
            throw new GException("'getRequestURL' returned bad URL: " + e.getMessage());
        }
    }

    public String getServiceWSDL(String serviceName) throws GException {
        if (this.wsdl == null) {
            MessageContext ctx = MessageContext.getCurrentContext();
            if (ctx == null) {
                return null;
            }
            this.wsdl = ctx.getService().getServiceDescription().getWSDLFile();
        }
        return this.wsdl;
    }
}

