/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.soap.axis;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.tulsoft.shared.GException;
import org.w3c.dom.Element;

public abstract class AxisUtils {
    public static void formatFault(AxisFault e, PrintStream out) {
        AxisUtils.formatFault(e, out, null, null);
    }

    public static String formatFault(AxisFault e, String endpoint, QName method) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AxisUtils.formatFault(e, new PrintStream(baos), endpoint, method);
        return baos.toString();
    }

    public static void formatFault(AxisFault e, PrintStream out, String endpoint, QName method) {
        out.println("===ERROR===");
        out.println("Fault details:");
        String faultString = e.getFaultString();
        if (!faultString.startsWith("java.net.ConnectException") && faultString.indexOf("Could not find class for the service named:") == -1) {
            Element[] details = e.getFaultDetails();
            for (int i = 0; i < details.length; ++i) {
                String s = details[i].toString().replaceAll("&lt;", "<");
                s = s.replaceAll("&gt;", ">");
                out.println(s);
            }
        }
        out.println("Fault string: " + faultString);
        out.println("Fault code:   " + e.getFaultCode());
        out.println("Fault actor:  " + e.getFaultActor());
        if (endpoint != null || method != null) {
            out.println("When calling:");
        }
        if (endpoint != null) {
            out.println("\t" + endpoint);
        }
        if (method != null) {
            out.println("\t" + method);
        }
        out.println("===========");
    }

    public static byte[][] aa2bb(Object value) throws GException {
        if (value instanceof byte[][]) {
            return (byte[][])value;
        }
        if (!(value instanceof ArrayList)) {
            throw new GException("aa2bb: The input is not of type ArrayList (but '" + value.getClass().getName() + "'.");
        }
        Object[] list = ((ArrayList)value).toArray();
        if (list.length == 0) {
            return new byte[][]{new byte[0]};
        }
        if (!(list[0] instanceof ArrayList)) {
            throw new GException("aa2bb: The nested element is of a wrong type '" + list[0].getClass().getName() + "'.");
        }
        Vector<byte[]> v = new Vector<byte[]>();
        for (int i = 0; i < list.length; ++i) {
            byte[] bytes;
            Object[] list2 = ((ArrayList)list[i]).toArray();
            if (list2.length > 0 && list2[0] instanceof Byte) {
                bytes = new byte[list2.length];
                for (int j = 0; j < list2.length; ++j) {
                    bytes[j] = (Byte)list2[j];
                }
            } else {
                throw new GException("aa2bb: The nested element is of an unexpected type '" + list2[0].getClass().getName());
            }
            v.addElement(bytes);
        }
        byte[][] results = new byte[v.size()][];
        v.copyInto((Object[])results);
        return results;
    }
}

