/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.loaders;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.tulsoft.shared.GException;

public final class ICreator {
    public static Object createInstance(Class fromClass, Class[] argsClasses, Object[] argsValues) throws GException {
        try {
            Constructor constructor = fromClass.getConstructor(argsClasses);
            return constructor.newInstance(argsValues);
        }
        catch (InstantiationException e) {
            throw new GException("InstantiationException: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new GException("IllegalAccessException: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new GException("IllegalArgumentException: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new GException("InvocationTargetException: " + e.getTargetException().toString(), e);
        }
        catch (NoSuchMethodException e) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < argsClasses.length; ++i) {
                buf.append(argsClasses[i].getName() + " ");
            }
            throw new GException("NoSuchMethodException: " + fromClass.getName() + "(" + new String(buf) + ")", e);
        }
    }

    public static Object createInstance(String className, Class[] argsClasses, Object[] argsValues) throws GException {
        try {
            Class<?> classOf = Class.forName(className);
            return ICreator.createInstance(classOf, argsClasses, argsValues);
        }
        catch (GException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GException("Can't load class '" + className + "'. " + e.toString());
        }
    }

    public static Object createInstance(Class fromClass) throws GException {
        return ICreator.createInstance(fromClass, new Class[0], new Object[0]);
    }

    public static Object createInstance(String className) throws GException {
        return ICreator.createInstance(className, new Class[0], new Object[0]);
    }
}

