/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tulsoft.shared.StringUtils;
import org.tulsoft.tools.gui.AwtUtils;

public abstract class SwingUtils {
    public static final String VERSION = "$Id: SwingUtils.java,v 1.6 2007/03/25 18:55:18 marsenger Exp $";

    public static boolean checkJavaVersion() {
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.1.2") < 0) {
            System.err.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            return false;
        }
        return true;
    }

    public static void msg(Component parent, String title, Object msg, Icon icon) {
        if (msg instanceof String) {
            msg = StringUtils.customizeMsg((String)msg, 25);
        }
        if (icon == null) {
            JOptionPane.showMessageDialog(parent, msg, title, -1);
        } else {
            JOptionPane.showMessageDialog(parent, msg, title, -1, icon);
        }
    }

    public static boolean confirm(Component parent, Object msg, Icon icon) {
        int result = icon == null ? JOptionPane.showConfirmDialog(parent, msg, "Confirmation dialog", 0, 3) : JOptionPane.showConfirmDialog(parent, msg, "Confirmation dialog", 0, 3, icon);
        return result == 0;
    }

    public static JFrame createMainFrame(JComponent component, String title) {
        JFrame frame = SwingUtils._createMainFrame(component, title);
        frame.addWindowListener(AwtUtils.setWindowClosing());
        return frame;
    }

    public static JFrame createSoftMainFrame(JComponent component, String title) {
        JFrame frame = SwingUtils._createMainFrame(component, title);
        frame.addWindowListener(AwtUtils.setSoftWindowClosing());
        return frame;
    }

    static JFrame _createMainFrame(JComponent component, String title) {
        JFrame frame = new JFrame(title);
        JOptionPane.setRootFrame(frame);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)component, "Center");
        return frame;
    }

    public static void showMainFrame(JFrame frame, Dimension dim) {
        SwingUtils.showMainFrameRelativeTo(null, frame, dim.width, dim.height);
    }

    public static void showMainFrame(JFrame frame, int width, int height) {
        SwingUtils.showMainFrameRelativeTo(null, frame, width, height);
    }

    public static void showMainFrameRelativeTo(Component parent, JFrame frame, int width, int height) {
        frame.setSize(width, height);
        AwtUtils.setLocationRelativeTo(frame, parent);
        frame.show();
        frame.validate();
        frame.repaint();
    }

    public static void addComponent(JComponent parent, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor) {
        GridBagConstraints gbc = SwingUtils.createConstraints(gridx, gridy, gridwidth, gridheight, fill, anchor);
        parent.add(component, gbc);
    }

    public static void addComponent(JComponent parent, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, Insets insets) {
        GridBagConstraints gbc = SwingUtils.createConstraints(gridx, gridy, gridwidth, gridheight, fill, anchor);
        gbc.insets = insets;
        parent.add(component, gbc);
    }

    public static void addComponent(JComponent parent, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, double weightx, double weighty) {
        GridBagConstraints gbc = SwingUtils.createConstraints(gridx, gridy, gridwidth, gridheight, fill, anchor);
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        parent.add(component, gbc);
    }

    public static void addComponent(JComponent parent, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, double weightx, double weighty, Insets insets) {
        GridBagConstraints gbc = SwingUtils.createConstraints(gridx, gridy, gridwidth, gridheight, fill, anchor);
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        parent.add(component, gbc);
    }

    static GridBagConstraints createConstraints(int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        return gbc;
    }

    public static Icon createIcon(String path) {
        return SwingUtils.createIcon(path, null);
    }

    public static Icon createIcon(String path, Object owner) {
        return SwingUtils.createIcon(path, owner.getClass());
    }

    public static Icon createIcon(String path, Class c) {
        if (path == null) {
            return null;
        }
        File iconFile = new File(path);
        if (iconFile.isAbsolute()) {
            return new ImageIcon(path);
        }
        try {
            return new ImageIcon(new URL(path));
        }
        catch (MalformedURLException e) {
            URL imageURL = null;
            if (c != null) {
                imageURL = c.getClassLoader().getResource(path);
                if (imageURL != null) {
                    return new ImageIcon(imageURL);
                }
                String className = c.getName();
                int pkgEndIndex = className.lastIndexOf(46);
                if (pkgEndIndex > 0) {
                    String packageName = className.substring(0, pkgEndIndex);
                    String newPath = packageName.replace('.', '/') + "/" + path;
                    imageURL = c.getClassLoader().getResource(newPath);
                    if (imageURL != null) {
                        return new ImageIcon(imageURL);
                    }
                }
            }
            if ((imageURL = Thread.currentThread().getContextClassLoader().getResource(path)) != null) {
                return new ImageIcon(imageURL);
            }
            return null;
        }
    }

    public static void compact(JButton button) {
        if (button.getIcon() != null && "".equals(button.getText())) {
            Insets margin = button.getMargin();
            margin.left = margin.right = margin.top;
            button.setMargin(margin);
        }
    }

    public static void expandTree(JTree tree, DefaultMutableTreeNode fromNode) {
        Enumeration<TreeNode> en = fromNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            tree.expandPath(new TreePath(node.getPath()));
        }
    }

    public static void collapseTree(JTree tree, DefaultMutableTreeNode fromNode) {
        Enumeration<TreeNode> en = fromNode.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            tree.collapsePath(new TreePath(node.getPath()));
        }
    }
}

