/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class SteppedComboBox
extends JComboBox {
    protected int popupWidth;

    public SteppedComboBox() {
        this.init();
    }

    public SteppedComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    public SteppedComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public SteppedComboBox(Vector items) {
        super(items);
        this.init();
    }

    public void setPopupWidth(int width) {
        this.popupWidth = width;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        if (this.popupWidth < 1) {
            this.popupWidth = size.width;
        }
        return new Dimension(this.popupWidth, size.height);
    }

    protected void init() {
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    class SteppedComboBoxUI
    extends MetalComboBoxUI {
        SteppedComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            BasicComboPopup newPopup = new BasicComboPopup(this.comboBox){

                public void show() {
                    Dimension popupSize = ((SteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            newPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return newPopup;
        }
    }
}

