/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.SteppedComboBox;

public class JTextFieldWithHistory
extends SteppedComboBox {
    public static final String VERSION = "$Id: JTextFieldWithHistory.java,v 1.6 2007/03/25 18:55:18 marsenger Exp $";
    protected Preferences myNode;
    JTextField editorComponent;
    static final Font plainFont10 = new Font("Dialog", 0, 10);
    static final String HISTORY_NODE_NAME = "AAQnNpPKBSRk-history";

    public JTextFieldWithHistory() {
        this("");
    }

    public JTextFieldWithHistory(String initValue) {
        this.createItself(initValue, null);
    }

    public JTextFieldWithHistory(String initValue, String[] historyTexts) {
        this.createItself(initValue, historyTexts);
    }

    public JTextFieldWithHistory(String initValue, Class c, String preferenceNodeName) {
        this.myNode = c == null ? PrefsUtils.getNode(preferenceNodeName + "/" + HISTORY_NODE_NAME) : PrefsUtils.getNode(c, preferenceNodeName + "/" + HISTORY_NODE_NAME);
        String[] historyTexts = PrefsUtils.getValues(this.myNode);
        PrefsUtils.removeKeys(this.myNode);
        this.createItself(initValue, historyTexts);
    }

    public JTextFieldWithHistory(String initValue, String preferenceNodeName) {
        this(initValue, null, preferenceNodeName);
    }

    public JTextFieldWithHistory(String initValue, Object owner, String preferenceNodeName) {
        this(initValue, owner.getClass(), preferenceNodeName);
    }

    protected void createItself(String initValue, String[] historyTexts) {
        this.setEditable(true);
        this.setFont(plainFont10);
        Dimension d = this.getPreferredSize();
        this.setPreferredSize(new Dimension(50, d.height));
        this.setMinimumSize(this.getPreferredSize());
        if (historyTexts != null) {
            for (int i = 0; i < historyTexts.length; ++i) {
                this.addItem(historyTexts[i]);
            }
            if (initValue == null && historyTexts.length > 0) {
                initValue = historyTexts[0];
            }
        }
        this.editorComponent = (JTextField)this.getEditor().getEditorComponent();
        if (UUtils.isEmpty(initValue)) {
            this.setSelectedIndex(-1);
            this.editorComponent.setText("");
        } else {
            this.addItem(initValue);
            this.setSelectedItem(initValue);
        }
        this.editorComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JTextFieldWithHistory.this.addItem(JTextFieldWithHistory.this.editorComponent.getText());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Object item) {
        JTextFieldWithHistory jTextFieldWithHistory = this;
        synchronized (jTextFieldWithHistory) {
            try {
                String newItem = (String)item;
                if (UUtils.isEmpty(newItem)) {
                    return;
                }
                int maxItemLen = 0;
                int indexOfAlreadyExisting = -1;
                for (int i = 0; i < this.getItemCount(); ++i) {
                    String anItem = (String)this.getItemAt(i);
                    int len = anItem.length();
                    if (len > maxItemLen) {
                        maxItemLen = len;
                    }
                    if (!newItem.equals(anItem)) continue;
                    indexOfAlreadyExisting = i;
                    break;
                }
                if (indexOfAlreadyExisting == -1) {
                    super.addItem(item);
                } else {
                    this.removeItemAt(indexOfAlreadyExisting);
                    this.insertItemAt(item, 0);
                }
                this.setSelectedItem(item);
                int newItemLen = newItem.length();
                if (newItemLen > maxItemLen) {
                    this.setPopupWidth(this.getFontMetrics(this.getFont()).stringWidth(newItem));
                }
                if (this.myNode != null) {
                    PrefsUtils.updateKey(this.myNode, "" + UUtils.unique(), newItem);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void setText(String t) {
        this.addItem(t);
        this.setSelectedItem(t);
    }

    public String getText() {
        return (String)this.getSelectedItem();
    }

    public void addKeyListener(KeyListener l) {
        if (this.editorComponent != null) {
            this.editorComponent.addKeyListener(l);
        }
    }

    public void removeKeyListener(KeyListener l) {
        if (this.editorComponent != null) {
            this.editorComponent.removeKeyListener(l);
        }
    }

    public void addFocusListener(FocusListener l) {
        if (this.editorComponent != null) {
            this.editorComponent.addFocusListener(l);
        }
    }

    public void removeFocusListener(FocusListener l) {
        if (this.editorComponent != null) {
            this.editorComponent.removeFocusListener(l);
        }
    }
}

