/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.AwtUtils;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class JFileChooserWithHistory
extends JPanel {
    public static final String VERSION = "$Id: JFileChooserWithHistory.java,v 1.4 2007/03/25 18:55:18 marsenger Exp $";
    protected JTextFieldWithHistory textField;
    protected JFileChooser chooser;
    protected JButton chooserButton;
    protected Icon chooserButtonIcon;

    public JFileChooserWithHistory() {
        this.createItself();
    }

    public JFileChooserWithHistory(String initValue) {
        this.textField = new JTextFieldWithHistory(initValue);
        this.createItself();
    }

    public JFileChooserWithHistory(String initValue, String preferenceNodeName) {
        this.textField = new JTextFieldWithHistory(initValue, preferenceNodeName);
        this.createItself();
    }

    public JFileChooserWithHistory(String initValue, Class c, String preferenceNodeName) {
        this.textField = new JTextFieldWithHistory(initValue, c, preferenceNodeName);
        this.createItself();
    }

    public JFileChooserWithHistory(String initValue, Object owner, String preferenceNodeName) {
        this.textField = new JTextFieldWithHistory(initValue, owner, preferenceNodeName);
        this.createItself();
    }

    public JFileChooserWithHistory(String initValue, String[] historyTexts) {
        this.textField = new JTextFieldWithHistory(initValue, historyTexts);
        this.createItself();
    }

    protected void createItself() {
        this.chooser = new JFileChooser();
        String initValue = this.textField.getText();
        if (UUtils.notEmpty(initValue)) {
            File file = new File(initValue);
            this.chooser.setSelectedFile(file);
        }
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String fileName = JFileChooserWithHistory.this.textField.getText();
                if (UUtils.notEmpty(fileName)) {
                    JFileChooserWithHistory.this.chooser.setSelectedFile(new File(fileName));
                }
            }
        });
        this.chooserButton = this.getChooserButton();
        Dimension dim = new Dimension(this.chooserButton.getPreferredSize().width, this.textField.getPreferredSize().height);
        this.chooserButton.setPreferredSize(dim);
        this.setLayout(new GridBagLayout());
        SwingUtils.addComponent(this, this.textField, 0, 0, 1, 1, 2, 17, 1.0, 0.0);
        SwingUtils.addComponent(this, this.chooserButton, 1, 0, 1, 1, 0, 17, 0.0, 0.0);
    }

    protected Icon getIcon() {
        if (this.chooserButtonIcon == null) {
            this.chooserButtonIcon = SwingUtils.createIcon("images/open.gif", this);
        }
        return this.chooserButtonIcon;
    }

    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    public JTextFieldWithHistory getTextField() {
        return this.textField;
    }

    public JButton getChooserButton() {
        if (this.chooserButton != null) {
            return this.chooserButton;
        }
        JButton button = new JButton();
        button.setIcon(this.getIcon());
        button.setFocusPainted(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JFileChooserWithHistory.this.chooser.showDialog(null, null) != 0) {
                    return;
                }
                File file = JFileChooserWithHistory.this.chooser.getSelectedFile();
                JFileChooserWithHistory.this.textField.setText(file.getAbsolutePath());
            }
        });
        SwingUtils.compact(button);
        return button;
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    public void setSelectedFile(File file) {
        this.chooser.setSelectedFile(file);
        this.textField.setText(file.getAbsolutePath());
    }

    public void setEnabled(boolean enabled) {
        this.chooserButton.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        AwtUtils.redisplay(this);
    }
}

