/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class AwtUtils {
    public static final String VERSION = "$Id: AwtUtils.java,v 1.1 2005/09/13 07:31:44 marsenger Exp $";

    public static WindowListener setWindowClosing() {
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        return l;
    }

    public static WindowListener setSoftWindowClosing() {
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Frame)e.getSource()).dispose();
            }
        };
        return l;
    }

    public static void setLocationRelativeTo(Component newC, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = newC.getSize();
            Dimension screenSize = newC.getToolkit().getScreenSize();
            newC.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        } else {
            Dimension invokerSize = c.getSize();
            Point invokerScreenLocation = c.getLocationOnScreen();
            Rectangle dialogBounds = newC.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - dialogBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - dialogBounds.height >> 1);
            Dimension ss = newC.getToolkit().getScreenSize();
            if (dy + dialogBounds.height > ss.height) {
                dy = ss.height - dialogBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - dialogBounds.width;
            }
            if (dx + dialogBounds.width > ss.width) {
                dx = ss.width - dialogBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            newC.setLocation(dx, dy);
        }
    }

    public static Frame getTopLevelParent(Component component) {
        Component c = component;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (c instanceof Frame) {
            return (Frame)c;
        }
        return null;
    }

    public static void redisplay(Component comp) {
        if (comp != null) {
            comp.invalidate();
            comp.validate();
            comp.repaint();
        }
    }

    public static void updateComponentsOnEdges(Container container) {
        int j;
        int i;
        GridBagConstraints gbc;
        if (!(container.getLayout() instanceof GridBagLayout)) {
            return;
        }
        GridBagLayout gridbag = (GridBagLayout)container.getLayout();
        boolean weightxFound = false;
        boolean weightyFound = false;
        int maxGridX = -1;
        int maxGridY = -1;
        Component[] comps = container.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            gbc = gridbag.getConstraints(comps[i2]);
            if (gbc.gridx == -1 || gbc.gridy == -1) {
                return;
            }
            if (gbc.gridx > maxGridX) {
                maxGridX = gbc.gridx;
            }
            if (gbc.gridy > maxGridY) {
                maxGridY = gbc.gridy;
            }
            if (gbc.weightx > 0.0) {
                weightxFound = true;
            }
            if (!(gbc.weighty > 0.0)) continue;
            weightyFound = true;
        }
        if (maxGridX == -1) {
            return;
        }
        Component[][] matrix = new Component[maxGridX + 1][maxGridY + 1];
        for (int i3 = 0; i3 < comps.length; ++i3) {
            gbc = gridbag.getConstraints(comps[i3]);
            int maxJ = Math.min(gbc.gridx + gbc.gridwidth, maxGridX + 1);
            for (int j2 = gbc.gridx; j2 < (gbc.gridwidth == 0 ? maxGridX + 1 : maxJ); ++j2) {
                int maxK = Math.min(gbc.gridy + gbc.gridheight, maxGridY + 1);
                for (int k = gbc.gridy; k < (gbc.gridheight == 0 ? maxGridY + 1 : maxK); ++k) {
                    matrix[j2][k] = comps[i3];
                }
            }
        }
        if (!weightyFound) {
            block4: for (i = 0; i <= maxGridX; ++i) {
                for (j = maxGridY; j >= 0; --j) {
                    Component comp = matrix[i][j];
                    if (comp == null) continue;
                    gbc = gridbag.getConstraints(comp);
                    gbc.weighty = 1.0;
                    gbc.gridheight = 0;
                    gridbag.setConstraints(comp, gbc);
                    continue block4;
                }
            }
        }
        if (!weightxFound) {
            block6: for (i = 0; i <= maxGridY; ++i) {
                for (j = maxGridX; j >= 0; --j) {
                    Component comp = matrix[j][i];
                    if (comp == null) continue;
                    gbc = gridbag.getConstraints(comp);
                    gbc.weightx = 1.0;
                    gbc.gridwidth = 0;
                    gridbag.setConstraints(comp, gbc);
                    continue block6;
                }
            }
        }
    }
}

