/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.external;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tulsoft.tools.external.CatchOutput;

public class CatchOutputDefaultImpl
implements CatchOutput {
    public static final String VERSION = "$Id: CatchOutputDefaultImpl.java,v 1.1.1.1 2005/09/03 07:32:13 marsenger Exp $";
    protected String errorMessage = null;
    protected BufferedReader processOutput;
    protected StringBuffer buf = new StringBuffer();
    static final String PRG_ERROR_MSG = "Input is missing (for programmers: use setInputStream())";

    public CatchOutputDefaultImpl() {
    }

    public CatchOutputDefaultImpl(InputStream stream) {
        this.setInputStream(stream);
    }

    public void setInputStream(InputStream stream) {
        this.processOutput = new BufferedReader(new InputStreamReader(stream));
    }

    public void run() {
        if (!this.checkInput()) {
            return;
        }
        try {
            String line;
            while ((line = this.processOutput.readLine()) != null) {
                this.buf.append(line);
                this.buf.append("\n");
            }
        }
        catch (IOException e) {
            this.errorMessage = "Error by reading application output: " + e.toString();
        }
    }

    public String getData() {
        return new String(this.buf);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected boolean checkInput() {
        if (this.processOutput == null) {
            this.errorMessage = PRG_ERROR_MSG;
            return false;
        }
        return true;
    }
}

