/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.debug;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DGUtils {
    public static String stackTraceToString(Throwable e) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            PrintWriter out = new PrintWriter(bout, true);
            e.printStackTrace(out);
            return bout.toString();
        }
        catch (Exception ex) {
            return "Error during printing an error message :-( " + ex.toString();
        }
    }

    public static String lineAndFile() {
        return DGUtils.lineAndFile(2);
    }

    public static String lineAndFile(int stackDepth) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            String trace = DGUtils.stackTraceToString(e);
            String find = "\tat ";
            int len = find.length();
            int start = DGUtils.nthIndexOf(trace, find, stackDepth, 0);
            int end = DGUtils.nthIndexOf(trace, find, 0, start + len);
            if (end == -1) {
                end = trace.length();
            }
            return trace.substring(start + len, end - 1);
        }
    }

    public static void printHT(int indent, Hashtable t, PrintStream out) {
        Enumeration en = t.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = t.get(key);
            if (value instanceof Hashtable) {
                DGUtils.doIndent(indent, out);
                out.println(key);
                DGUtils.printHT(indent + 1, (Hashtable)value, out);
                continue;
            }
            if (value instanceof Object[]) {
                DGUtils.doIndent(indent, out);
                out.println(key);
                DGUtils.printAR(indent, (Object[])value, out);
                continue;
            }
            DGUtils.doIndent(indent, out);
            out.println(key + " = " + value);
        }
    }

    public static void printAR(Object[] a) {
        DGUtils.printAR(0, a, System.out);
    }

    public static void printAR(int indent, Object[] a, PrintStream out) {
        if (a == null) {
            DGUtils.doIndent(indent, out);
            out.println("null");
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            DGUtils.doIndent(indent, out);
            out.println("[" + i + "]");
            if (a[i] == null) {
                DGUtils.doIndent(indent, out);
                out.println("null");
                continue;
            }
            if (a[i] instanceof Hashtable) {
                DGUtils.printHT(indent + 1, (Hashtable)a[i], out);
                continue;
            }
            DGUtils.doIndent(indent, out);
            out.println(a[i].toString());
        }
    }

    private static void doIndent(int indent, PrintStream out) {
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
    }

    private static int nthIndexOf(String s, String find, int n) {
        return DGUtils.nthIndexOf(s, find, n, 0);
    }

    private static int nthIndexOf(String s, String find, int n, int from) {
        int f = 0;
        int len = find.length();
        f = s.indexOf(find, f + from);
        for (int i = 0; i < n && f != -1; ++i) {
            f = s.indexOf(find, f + len);
        }
        return f;
    }
}

