/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class BaseCmdLine {
    protected Hashtable<String, Object> knownParams;
    protected boolean ignoreCase = false;
    public String[] params;
    public static final String DO_NOT_ARGS = "donotargs";
    public static final String KEEP_QUOTES = "keepquotes";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseCmdLine(String[] argv) {
        if (System.getProperty(DO_NOT_ARGS) == null) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-argsfile")) {
                    if (i >= argv.length - 1) continue;
                    String argsfile = argv[++i];
                    BufferedReader data = null;
                    try {
                        String line;
                        data = new BufferedReader(new InputStreamReader(new FileInputStream(argsfile)));
                        while ((line = data.readLine()) != null) {
                            String contents = line.trim();
                            if (contents.startsWith("#") || "".equals(contents)) continue;
                            if (contents.startsWith("\"") && contents.endsWith("\"") || contents.startsWith("'") && contents.endsWith("'")) {
                                contents = contents.substring(1, contents.length() - 1);
                            }
                            v.addElement(contents);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        System.err.println("Problems with file '" + argsfile + "': " + e.toString());
                        continue;
                    }
                    finally {
                        try {
                            if (data != null) {
                                data.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                }
                v.addElement(argv[i]);
            }
            this.params = new String[v.size()];
            v.copyInto(this.params);
        } else {
            this.params = new String[argv.length];
            System.arraycopy(argv, 0, this.params, 0, argv.length);
        }
        if (System.getProperty(KEEP_QUOTES) == null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (!"\"\"".equals(this.params[i])) continue;
                this.params[i] = "";
            }
        }
        this.knownParams = new Hashtable();
    }

    public BaseCmdLine(String[] argv, String[] names, int[] lengths) {
        this(argv, false, names, lengths);
    }

    public BaseCmdLine(String[] argv, boolean ignoreCase) {
        this(argv);
        this.ignoreCase = ignoreCase;
    }

    public BaseCmdLine(String[] argv, boolean ignoreCase, String[] names, int[] lengths) {
        this(argv, ignoreCase);
        for (int i = 0; i < Math.min(names.length, lengths.length); ++i) {
            this.getParam(names[i], lengths[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasParam(String name) {
        if (this.ignoreCase) {
            name = name.toUpperCase();
        }
        if (this.knownParams.containsKey(name)) {
            return true;
        }
        String[] stringArray = this.params;
        synchronized (this.params) {
            for (int i = 0; i < this.params.length; ++i) {
                if ((!this.ignoreCase || !this.params[i].equalsIgnoreCase(name)) && !this.params[i].equals(name)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public boolean hasOption(String name) {
        this.getParam(name, 0);
        return this.hasParam(name);
    }

    public String getParam(String name) {
        return this.getParam(name, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParam(String name, int length) {
        Object obj;
        if (length < 0) {
            length = 1;
        }
        String[] results = new String[length];
        if (this.ignoreCase) {
            name = name.toUpperCase();
        }
        if ((obj = this.knownParams.get(name)) != null) {
            if (length > 0) {
                String[] values = (String[])obj;
                System.arraycopy(values, 0, results, 0, Math.min(results.length, values.length));
            }
            return results;
        }
        String[] stringArray = this.params;
        synchronized (this.params) {
            for (int i = 0; i < this.params.length; ++i) {
                int j;
                if ((!this.ignoreCase || !this.params[i].equalsIgnoreCase(name)) && !this.params[i].equals(name)) continue;
                if (length > 0 && i < this.params.length - 1) {
                    System.arraycopy(this.params, i + 1, results, 0, Math.min(length, this.params.length - i - 1));
                }
                this.knownParams.put(name, results);
                Vector<String> v = new Vector<String>();
                for (j = 0; j < i; ++j) {
                    v.addElement(this.params[j]);
                }
                for (j = i + 1 + length; j < this.params.length; ++j) {
                    v.addElement(this.params[j]);
                }
                this.params = new String[v.size()];
                v.copyInto(this.params);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return results;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return results;
        }
    }
}

