/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.shared;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class UUtils {
    public static final String VERSION = "$Id: UUtils.java,v 1.5 2007/03/25 18:55:17 marsenger Exp $";
    private static int counter = 0;
    private static long lastReturned = new Date().getTime();

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public static boolean notEmpty(String value) {
        return !UUtils.isEmpty(value);
    }

    public static boolean is(String str) {
        return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "on".equalsIgnoreCase(str) || "+".equals(str) || "1".equals(str);
    }

    public static String unique() {
        long now = new Date().getTime();
        if (now == lastReturned) {
            return now + "." + ++counter;
        }
        lastReturned = now;
        return "" + now;
    }

    public static String formatDate(Date date) {
        DateFormat df = DateFormat.getDateTimeInstance();
        df.setCalendar(Calendar.getInstance());
        return df.format(date) + " (" + df.getTimeZone().getID() + ")";
    }

    public static String formatDate() {
        return UUtils.formatDate(new Date());
    }

    public static String formatDate(String seconds) {
        Date date;
        try {
            date = new Date(new Long(seconds) * 1000L);
        }
        catch (NumberFormatException e) {
            return "unknown";
        }
        return UUtils.formatDate(date);
    }

    public static String formatDate(long miliSeconds) {
        Date date;
        try {
            date = new Date(miliSeconds);
        }
        catch (NumberFormatException e) {
            return "unknown";
        }
        return UUtils.formatDate(date);
    }

    public static int toInt(String str) {
        int i;
        try {
            i = str == null ? 0 : Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    public static String[] arraymerge(String[][] arr) {
        int entireLen = 0;
        for (int i = 0; i < arr.length; ++i) {
            entireLen += arr[i].length;
        }
        String[] result = new String[entireLen];
        int cumulativeLen = 0;
        for (int i = 0; i < arr.length; ++i) {
            System.arraycopy(arr[i], 0, result, cumulativeLen, arr[i].length);
            cumulativeLen += arr[i].length;
        }
        return result;
    }

    public static String[] uniqueArraymerge(String[][] arr) {
        Vector<String> v = new Vector<String>();
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                String value = arr[i][j];
                if (h.containsKey(value)) continue;
                h.put(value, "");
                v.addElement(value);
            }
        }
        Object[] merged = new String[v.size()];
        v.copyInto(merged);
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] join(String[] arr1, String[] arr2) {
        String[] stringArray = arr1;
        synchronized (arr1) {
            String[] stringArray2 = arr2;
            synchronized (arr2) {
                String[] result = new String[arr1.length + arr2.length];
                System.arraycopy(arr1, 0, result, 0, arr1.length);
                System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
        }
    }

    public static void setSystemProperty(String name, String value) {
        try {
            if (System.getProperty(name) == null) {
                Properties props = System.getProperties();
                props.put(name, value);
                System.setProperties(props);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void setSystemProperty(String name, String value, boolean forceOverwrite) {
        try {
            if (forceOverwrite || System.getProperty(name) == null) {
                Properties props = System.getProperties();
                props.put(name, value);
                System.setProperties(props);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

