/*
 * Decompiled with CFR 0.152.
 */
import org.tulsoft.tools.BaseCmdLine;

public class TestBaseCmdLine {
    static boolean useAsOption = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage:\n\tjava -Dn=<name> [-Dl=<length>] TestBaseCmdLine <some arguments>\nwhere\n\t<name> is one of the command-line arguments, and\n\t<length> is a number of subsequent arguments to be taken.");
            System.exit(1);
        }
        String name = System.getProperty("n");
        String s = System.getProperty("l");
        int len = -1;
        if (s == null) {
            useAsOption = true;
        } else {
            try {
                len = new Integer(s);
            }
            catch (NumberFormatException _ex) {
                // empty catch block
            }
            if (len < 0) {
                len = 1;
            }
        }
        if (name != null) {
            System.out.println("Case sensitive search:");
            TestBaseCmdLine.printIt(new BaseCmdLine(args), name, len);
            System.out.println("Case insensitive search:");
            TestBaseCmdLine.printIt(new BaseCmdLine(args, true), name, len);
            System.out.println("Pure argument list cleaning:");
            TestBaseCmdLine.printRest(new BaseCmdLine(args, new String[]{name}, new int[]{useAsOption ? 0 : len}));
            System.out.println("All arguments:");
        }
        TestBaseCmdLine.printRest(new BaseCmdLine(args));
    }

    private static void printIt(BaseCmdLine basecmdline, String name, int length) {
        System.out.println("\thasParam(\"" + name + "\") =>\t" + basecmdline.hasParam(name));
        if (useAsOption) {
            System.out.println("\thasOption(\"" + name + "\") =>\t" + basecmdline.hasOption(name));
        } else if (length == 1) {
            System.out.println("\tgetParam(\"" + name + "\") =>\t" + basecmdline.getParam(name));
        } else {
            String[] as = basecmdline.getParam(name, length);
            System.out.println("\tgetParam(\"" + name + "\"," + length + ") =>");
            for (int j = 0; j < as.length; ++j) {
                System.out.println("\t\t\t" + as[j]);
            }
        }
    }

    private static void printRest(BaseCmdLine basecmdline) {
        System.out.println("\tparams => ");
        for (int i = 0; i < basecmdline.params.length; ++i) {
            System.out.println("\t" + (i + 1) + ":\t" + basecmdline.params[i]);
        }
    }
}

