/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.taverna.enactor.entities;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;

public class TransformDataThing {
    private static Logger logger = Logger.getLogger((Class)TransformDataThing.class);

    public static DataThing replacelsid(DataThing outdt, Map inputMap, Map outputMap) {
        try {
            Object newValue = TransformDataThing.replaceLSIDsInDataThingValues(inputMap, outputMap, outdt, outdt.getDataObject());
            DataThing newdt = new DataThing(newValue);
            newdt.copyMetadataFrom(outdt);
            return newdt;
        }
        catch (Exception e) {
            logger.error((Object)"replacelsid failed", (Throwable)e);
            return outdt;
        }
    }

    protected static Object replaceLSIDsInDataThingValues(Map inputMap, Map outputMap, DataThing dt, Object value) {
        ArrayList<Object> newValue = value;
        if (value instanceof String) {
            String asString = (String)((Object)value);
            int index = asString.indexOf("replacelsid:");
            if (index < 0) {
                return value;
            }
            StringBuffer buffer = new StringBuffer((String)((Object)value));
            while (index >= 0) {
                int from = index + "replacelsid:".length();
                int len = 0;
                while (from + len < buffer.length() && Character.isLetterOrDigit(buffer.charAt(from + len))) {
                    ++len;
                }
                String portname = buffer.substring(from, from + len);
                DataThing portvalue = (DataThing)inputMap.get(portname);
                if (portvalue == null) {
                    portvalue = (DataThing)outputMap.get(portname);
                }
                if (portvalue == null) {
                    logger.error((Object)("replacedlsid unknown port '" + portname + "'"));
                } else {
                    boolean error = false;
                    Object elementvalue = portvalue.getDataObject();
                    while (from + len < buffer.length() && buffer.charAt(from + len) == '[') {
                        ++len;
                        int numlen = 0;
                        while (from + len + numlen < buffer.length() && Character.isDigit(buffer.charAt(from + len + numlen))) {
                            ++numlen;
                        }
                        if (from + len + numlen >= buffer.length() || buffer.charAt(from + len + numlen) != ']') {
                            logger.error((Object)("replacelsid with ill-formed array index: " + buffer.substring(from + len)));
                            error = true;
                            break;
                        }
                        int arrayindex = 0;
                        try {
                            arrayindex = new Integer(buffer.substring(from + len, from + len + numlen));
                        }
                        catch (Exception e) {
                            logger.error((Object)("replacelsid with ill-formed array index: " + buffer.substring(from + len)));
                            error = true;
                            break;
                        }
                        len = len + numlen + 1;
                        if (elementvalue.getClass().isArray()) {
                            if (arrayindex < 0 || arrayindex >= Array.getLength(elementvalue)) {
                                logger.error((Object)("replacelsid with array index [" + arrayindex + "] out of bounds (0.." + Array.getLength(elementvalue) + ")"));
                                error = true;
                                break;
                            }
                            elementvalue = Array.get(elementvalue, arrayindex);
                            continue;
                        }
                        if (elementvalue instanceof List) {
                            if (arrayindex < 0 || arrayindex >= ((List)elementvalue).size()) {
                                logger.error((Object)("replacelsid with array index [" + arrayindex + "] out of bounds (0.." + ((List)elementvalue).size() + ")"));
                                error = true;
                                break;
                            }
                            elementvalue = ((List)elementvalue).get(arrayindex);
                            continue;
                        }
                        logger.error((Object)("replacelsid with array index [" + arrayindex + "] for non-array/List value, type " + elementvalue.getClass().getName()));
                        error = true;
                        break;
                    }
                    if (!error) {
                        String elementlsid = portvalue.getLSID(elementvalue);
                        if (elementlsid == null || elementlsid.length() == 0) {
                            logger.error((Object)("replacelsid could not find LSID for " + elementvalue));
                        } else {
                            buffer.replace(index, from + len, elementlsid);
                        }
                    }
                }
                index = buffer.indexOf("replacelsid:", index + 1);
            }
            newValue = buffer.toString();
        } else {
            if (value instanceof byte[] || value instanceof byte[][]) {
                return value;
            }
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(value, i, TransformDataThing.replaceLSIDsInDataThingValues(inputMap, outputMap, dt, Array.get(value, i)));
                }
            } else if (value instanceof List) {
                ArrayList<Object> newList = new ArrayList<Object>((List)value);
                for (int i = 0; i < newList.size(); ++i) {
                    newList.set(i, TransformDataThing.replaceLSIDsInDataThingValues(inputMap, outputMap, dt, newList.get(i)));
                }
                newValue = newList;
            } else {
                logger.warn((Object)("replacelsid ignoring a " + value.getClass().getName() + " - sorry"));
            }
        }
        if (newValue != value) {
            dt.setLSID(newValue, dt.getLSID(value));
        }
        return newValue;
    }
}

