/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.taverna.enactor.entities;

import java.beans.IntrospectionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.BaclavaIterator;
import org.embl.ebi.escience.baclava.BaclavaIteratorNode;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.JoinIteratorNode;
import org.embl.ebi.escience.baclava.ResumableIterator;
import org.embl.ebi.escience.baclava.store.BaclavaDataService;
import org.embl.ebi.escience.baclava.store.DuplicateLSIDException;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.AnnotationTemplate;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.IterationCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessFailureEvent;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowEventDispatcher;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowInstanceImpl;
import org.embl.ebi.escience.scufl.provenance.process.AlternateProcessScheduled;
import org.embl.ebi.escience.scufl.provenance.process.ConstructingIterator;
import org.embl.ebi.escience.scufl.provenance.process.DataMismatchError;
import org.embl.ebi.escience.scufl.provenance.process.Invoking;
import org.embl.ebi.escience.scufl.provenance.process.InvokingWithIteration;
import org.embl.ebi.escience.scufl.provenance.process.ProcessComplete;
import org.embl.ebi.escience.scufl.provenance.process.ProcessEvent;
import org.embl.ebi.escience.scufl.provenance.process.ProcessScheduled;
import org.embl.ebi.escience.scufl.provenance.process.ServiceError;
import org.embl.ebi.escience.scufl.provenance.process.ServiceFailure;
import org.embl.ebi.escience.scufl.provenance.process.WaitingToRetry;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.soton.itinnovation.freefluo.core.event.RunEvent;
import uk.ac.soton.itinnovation.freefluo.core.flow.Flow;
import uk.ac.soton.itinnovation.freefluo.core.task.AbstractTask;
import uk.ac.soton.itinnovation.freefluo.core.task.Task;
import uk.ac.soton.itinnovation.freefluo.main.Engine;
import uk.ac.soton.itinnovation.freefluo.task.LogLevel;
import uk.ac.soton.itinnovation.taverna.enactor.entities.PortTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TransformDataThing;

public class ProcessorTask
extends AbstractTask {
    public static Namespace provNS = Namespace.getNamespace((String)"p", (String)"http://org.embl.ebi.escience/xscuflprovenance/0.1alpha");
    public static final String REPORT_NAMESPACE = "http://www.it-innovation.soton.ac.uk/taverna/workflow/enactor/progress";
    private static WorkflowEventDispatcher DISPATCHER = WorkflowEventDispatcher.DISPATCHER;
    static BaclavaDataService STORE = null;
    private Processor activeProcessor = null;
    private Map activeInputMapping = null;
    private Map activeOutputMapping = null;
    private List provenanceList = new ArrayList();
    public WorkflowInstance workflowInstance = null;
    protected static final Namespace PROVENANCE_NAMESPACE;
    protected Processor proc = null;
    protected LogLevel logLevel = null;
    private Logger logger = Logger.getLogger((Class)ProcessorTask.class);
    private String userID;
    private String userCtx;
    private List eventList;
    private Exception faultCausingException = null;

    public List getProvenanceList() {
        return this.provenanceList;
    }

    private synchronized void schedule(Processor theProcessor) {
        this.activeProcessor = theProcessor;
        this.activeInputMapping = null;
        this.activeOutputMapping = null;
        this.eventList.add(new ProcessScheduled(theProcessor));
    }

    private synchronized void schedule(AlternateProcessor theAlternate) {
        this.activeProcessor = theAlternate.getProcessor();
        this.activeInputMapping = theAlternate.getInputMapping();
        this.activeOutputMapping = new HashMap();
        Iterator i = theAlternate.getOutputMapping().keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)theAlternate.getOutputMapping().get(key);
            this.activeOutputMapping.put(value, key);
        }
        this.eventList.add(new AlternateProcessScheduled(this.activeProcessor));
    }

    public void handleRun(RunEvent runEvents) {
        try {
            Flow flow = this.getFlow();
            String flowID = flow.getFlowId();
            Engine e = flow.getEngine();
            this.workflowInstance = new WorkflowInstanceImpl(e, flowID);
            for (int i = -1; i < this.proc.getAlternatesArray().length; ++i) {
                if (i > -1) {
                    this.schedule(this.proc.getAlternatesArray()[i]);
                }
                try {
                    this.invoke();
                    break;
                }
                catch (TaskExecutionException tee) {
                    if (i != this.proc.getAlternatesArray().length - 1) continue;
                    throw tee;
                }
            }
            this.complete();
        }
        catch (Exception ex) {
            this.eventList.add(new ServiceFailure());
            ex.printStackTrace();
            this.faultCausingException = ex;
            this.logger.error((Object)ex);
            this.fail("Task " + this.getTaskId() + " in flow " + this.getFlow().getFlowId() + " failed.  " + ex.getMessage());
            DISPATCHER.fireProcessFailed(new ProcessFailureEvent(this.workflowInstance, this.activeProcessor, ex));
        }
    }

    private synchronized void invoke() throws TaskExecutionException {
        String portName;
        HashMap<String, DataThing> inputMap = new HashMap<String, DataThing>();
        Map outputMap = null;
        Iterator i = this.getParents().iterator();
        while (i.hasNext()) {
            Task task = (Task)i.next();
            if (!(task instanceof PortTask)) continue;
            PortTask inputPortTask = (PortTask)task;
            DataThing dataThing = inputPortTask.getData();
            portName = inputPortTask.getScuflPort().getName();
            inputMap.put(portName, dataThing);
        }
        if (this.iterationRequired()) {
            outputMap = this.invokeWithIteration(inputMap);
        } else {
            outputMap = this.invokeWithoutIteration(inputMap);
            DISPATCHER.fireProcessCompleted(new ProcessCompletionEvent(false, inputMap, outputMap, this.activeProcessor, this.workflowInstance));
        }
        HashSet<DataThing> alreadyStoredThings = new HashSet<DataThing>();
        Iterator i2 = this.getChildren().iterator();
        while (i2.hasNext()) {
            Task task = (Task)i2.next();
            if (!(task instanceof PortTask)) continue;
            PortTask outputPortTask = (PortTask)task;
            portName = outputPortTask.getScuflPort().getName();
            DataThing resultDataThing = (DataThing)outputMap.get(portName);
            if (resultDataThing != null) {
                outputPortTask.setData(resultDataThing);
                if (STORE == null) continue;
                try {
                    if (alreadyStoredThings.contains(outputPortTask.getData())) continue;
                    STORE.storeDataThing(outputPortTask.getData(), true);
                    alreadyStoredThings.add(outputPortTask.getData());
                }
                catch (DuplicateLSIDException dple) {
                }
                catch (Exception e) {
                    System.out.println("Exception thrown while trying to store a datathing,\ndisabling further stores.");
                    e.printStackTrace();
                    STORE = null;
                }
                continue;
            }
            this.eventList.add(new ServiceError(new RuntimeException("Output '" + portName + "' was declared but never created!")));
            throw new TaskExecutionException("Output port '" + portName + "' not populated by service instance");
        }
        this.eventList.add(new ProcessComplete());
    }

    private synchronized Map invokeOnce(Map inputMap) throws TaskExecutionException {
        Iterator i;
        ProcessorTaskWorker worker = ProcessorHelper.getTaskWorker(this.activeProcessor);
        Map output = null;
        if (this.activeInputMapping == null) {
            output = this.doInvocationWithRetryLogic(worker, inputMap);
        } else {
            HashMap<String, DataThing> taskInput = new HashMap<String, DataThing>();
            i = inputMap.keySet().iterator();
            while (i.hasNext()) {
                String originalInputName = (String)i.next();
                DataThing inputItem = (DataThing)inputMap.get(originalInputName);
                String targetInputName = (String)this.activeInputMapping.get(originalInputName);
                if (targetInputName == null) {
                    targetInputName = originalInputName;
                }
                if (inputItem == null) continue;
                taskInput.put(targetInputName, inputItem);
            }
            output = this.doInvocationWithRetryLogic(worker, taskInput);
        }
        if (this.activeOutputMapping == null) {
            return output;
        }
        HashMap<String, DataThing> taskOutput = new HashMap<String, DataThing>();
        i = output.keySet().iterator();
        while (i.hasNext()) {
            String realOutputName = (String)i.next();
            String targetOutputName = (String)this.activeOutputMapping.get(realOutputName);
            if (targetOutputName == null) {
                targetOutputName = realOutputName;
            }
            DataThing outputItem = (DataThing)output.get(realOutputName);
            taskOutput.put(targetOutputName, outputItem);
        }
        return taskOutput;
    }

    private void fillAllLSIDs(Map inputMap) {
        Iterator i = inputMap.values().iterator();
        while (i.hasNext()) {
            ((DataThing)i.next()).fillLSIDValues();
        }
    }

    private void transformOutputDataThings(Map inputMap, Map outputMap) {
        String name;
        if (outputMap == null) {
            return;
        }
        HashMap<String, DataThing> newMap = new HashMap<String, DataThing>();
        Iterator i = outputMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            DataThing dataThing = (DataThing)outputMap.get(name);
            if (dataThing == null || !name.startsWith("replacelsid")) continue;
            newMap.put(name, TransformDataThing.replacelsid(dataThing, inputMap, outputMap));
        }
        i = newMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            outputMap.remove(name);
            outputMap.put(name, newMap.get(name));
        }
    }

    private Map doInvocationWithRetryLogic(ProcessorTaskWorker worker, Map inputMap) throws TaskExecutionException {
        try {
            return this.runAndGenerateTemplates(worker, inputMap);
        }
        catch (TaskExecutionException tee) {
            this.eventList.add(new ServiceError(tee));
            int maxRetries = this.activeProcessor.getRetries();
            if (maxRetries == 0) {
                throw tee;
            }
            int baseTimeout = this.activeProcessor.getRetryDelay();
            double backoff = this.activeProcessor.getBackoff();
            for (int i = 0; i < maxRetries; ++i) {
                int waitTime = (int)((double)baseTimeout * Math.pow(backoff, i));
                try {
                    this.eventList.add(new WaitingToRetry(waitTime, i + 1, maxRetries));
                    Thread.sleep(waitTime);
                    return this.runAndGenerateTemplates(worker, inputMap);
                }
                catch (InterruptedException ie) {
                    TaskExecutionException t = new TaskExecutionException("Interrupted during wait to retry");
                    t.initCause(ie);
                    this.eventList.add(new ServiceError(t));
                    throw t;
                }
                catch (TaskExecutionException t) {
                    this.eventList.add(new ServiceError(t));
                    continue;
                }
            }
            throw new TaskExecutionException("No retries remaining");
        }
    }

    private Map runAndGenerateTemplates(ProcessorTaskWorker worker, Map inputMap) throws TaskExecutionException {
        Map outputMap = worker.execute(inputMap, this);
        this.fillAllLSIDs(outputMap);
        this.transformOutputDataThings(inputMap, outputMap);
        AnnotationTemplate[] templates = this.activeProcessor.getAnnotationTemplates();
        AnnotationTemplate[] defaultTemplates = this.activeProcessor.defaultAnnotationTemplates();
        if (templates.length > 0 || defaultTemplates.length > 0) {
            String annotation;
            int i;
            String objectLSID;
            HashMap<String, String> templateInputs = new HashMap<String, String>();
            HashMap<String, String> templateOutputs = new HashMap<String, String>();
            Iterator i2 = inputMap.keySet().iterator();
            while (i2.hasNext()) {
                String inputName = (String)i2.next();
                DataThing inputValue = (DataThing)inputMap.get(inputName);
                objectLSID = inputValue.getLSID(inputValue.getDataObject());
                if (objectLSID == null || objectLSID.equals("")) continue;
                templateInputs.put(inputName, objectLSID);
            }
            i2 = outputMap.keySet().iterator();
            while (i2.hasNext()) {
                String outputName = (String)i2.next();
                DataThing outputValue = (DataThing)outputMap.get(outputName);
                objectLSID = outputValue.getLSID(outputValue.getDataObject());
                if (objectLSID == null || objectLSID.equals("")) continue;
                templateOutputs.put(outputName, objectLSID);
            }
            for (i = 0; i < templates.length; ++i) {
                annotation = templates[i].getTextAnnotation(templateInputs, templateOutputs);
                if (annotation == null) continue;
                this.provenanceList.add(AnnotationTemplate.convert(annotation));
                if (STORE == null) continue;
                STORE.storeMetadata(annotation);
            }
            for (i = 0; i < defaultTemplates.length; ++i) {
                annotation = defaultTemplates[i].getTextAnnotation(templateInputs, templateOutputs);
                if (annotation == null) continue;
                this.provenanceList.add(AnnotationTemplate.convert(annotation));
                if (STORE == null) continue;
                STORE.storeMetadata(annotation);
            }
        }
        return outputMap;
    }

    private synchronized Map invokeWithoutIteration(Map inputMap) throws TaskExecutionException {
        this.eventList.add(new Invoking());
        return this.invokeOnce(inputMap);
    }

    private synchronized boolean iterationRequired() {
        Iterator i = this.getParents().iterator();
        while (i.hasNext()) {
            String portType;
            Task task = (Task)i.next();
            if (!(task instanceof PortTask)) continue;
            PortTask inputPortTask = (PortTask)task;
            String portName = inputPortTask.getScuflPort().getName();
            DataThing dataThing = inputPortTask.getData();
            String dataType = dataThing.getSyntacticType().split("\\'")[0];
            if (dataType.equals(portType = inputPortTask.getScuflPort().getSyntacticType().split("\\'")[0])) continue;
            return true;
        }
        return false;
    }

    private synchronized Map invokeWithIteration(Map inputMap) throws TaskExecutionException {
        Iterator<Object> i;
        if (this.getProcessor().getIterationStrategy() == null) {
            this.eventList.add(new ConstructingIterator());
        } else {
            this.eventList.add(new ConstructingIterator(this.getProcessor().getIterationStrategy()));
        }
        HashMap<String, BaclavaIteratorNode> iteratorNodeMap = new HashMap<String, BaclavaIteratorNode>();
        Iterator i2 = this.getParents().iterator();
        while (i2.hasNext()) {
            Task task = (Task)i2.next();
            if (!(task instanceof PortTask)) continue;
            String portName = ((PortTask)task).getScuflPort().getName();
            String portType = ((PortTask)task).getScuflPort().getSyntacticType();
            DataThing portData = (DataThing)inputMap.get(portName);
            try {
                BaclavaIterator iterator = portData.iterator(portType);
                BaclavaIteratorNode iteratorNode = new BaclavaIteratorNode(iterator, portName);
                iteratorNodeMap.put(portName, iteratorNode);
            }
            catch (IntrospectionException ie) {
                this.eventList.add(new DataMismatchError());
                throw new TaskExecutionException("Unable to reconcile iterator types");
            }
        }
        ResumableIterator rootNode = null;
        if (this.getProcessor().getIterationStrategy() == null) {
            rootNode = new JoinIteratorNode();
            Iterator i3 = iteratorNodeMap.values().iterator();
            while (i3.hasNext()) {
                BaclavaIteratorNode iteratorNode = (BaclavaIteratorNode)i3.next();
                ((DefaultMutableTreeNode)((Object)rootNode)).add(iteratorNode);
            }
        } else {
            try {
                rootNode = this.getProcessor().getIterationStrategy().buildIterator(iteratorNodeMap);
            }
            catch (IntrospectionException ie) {
                this.eventList.add(new DataMismatchError());
                throw new TaskExecutionException("Unable to reconcile iterator types");
            }
        }
        HashMap collectionStructure = new HashMap();
        HashMap<String, DataThing> outputMap = new HashMap<String, DataThing>();
        Iterator i4 = this.getChildren().iterator();
        while (i4.hasNext()) {
            Task task = (Task)i4.next();
            if (!(task instanceof PortTask)) continue;
            PortTask outputPortTask = (PortTask)task;
            DataThing outputThing = new DataThing(new ArrayList());
            outputThing.fillLSIDValues();
            String collectionLSID = outputThing.getLSID(outputThing.getDataObject());
            outputMap.put(outputPortTask.getScuflPort().getName(), outputThing);
            collectionStructure.put(collectionLSID, new HashSet());
        }
        HashMap<String, String> inputNameToLSID = new HashMap<String, String>();
        HashMap inputShredding = new HashMap();
        Iterator i5 = this.getParents().iterator();
        while (i5.hasNext()) {
            Task task = (Task)i5.next();
            if (!(task instanceof PortTask)) continue;
            PortTask inputPortTask = (PortTask)task;
            DataThing inputThing = inputPortTask.getData();
            String inputLSID = inputThing.getLSID(inputThing.getDataObject());
            String inputName = inputPortTask.getScuflPort().getName();
            inputNameToLSID.put(inputName, inputLSID);
            inputShredding.put(inputLSID, new HashSet());
        }
        int currentIteration = 0;
        int totalIterations = rootNode.size();
        while (rootNode.hasNext()) {
            Map inputSet = (Map)rootNode.next();
            i = inputSet.keySet().iterator();
            while (i.hasNext()) {
                String inputName = (String)i.next();
                DataThing inputThing = (DataThing)inputSet.get(inputName);
                String inputThingLSID = inputThing.getLSID(inputThing.getDataObject());
                String primaryLSID = (String)inputNameToLSID.get(inputName);
                Set shredding = (Set)inputShredding.get(primaryLSID);
                shredding.add(inputThingLSID);
            }
            int[] currentLocation = rootNode.getCurrentLocation();
            this.eventList.add(new InvokingWithIteration(++currentIteration, totalIterations));
            Map singleResultMap = this.invokeOnce(inputSet);
            DISPATCHER.fireProcessCompleted(new ProcessCompletionEvent(true, inputSet, singleResultMap, this.activeProcessor, this.workflowInstance));
            Iterator l = singleResultMap.keySet().iterator();
            while (l.hasNext()) {
                String outputName = (String)l.next();
                DataThing outputValue = (DataThing)singleResultMap.get(outputName);
                Object dataObject = outputValue.getDataObject();
                if (!outputMap.containsKey(outputName)) continue;
                DataThing targetThing = (DataThing)outputMap.get(outputName);
                targetThing.fillLSIDValues();
                List targetList = (List)targetThing.getDataObject();
                this.insertObjectInto(dataObject, targetList, currentLocation, targetThing);
                targetThing.copyMetadataFrom(outputValue);
                String originalLSID = targetThing.getLSID(dataObject);
                String collectionLSID = targetThing.getLSID(targetList);
                ((Set)collectionStructure.get(collectionLSID)).add(originalLSID);
            }
        }
        HashSet<String> removeKeys = new HashSet<String>();
        i = inputShredding.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set shredSet = (Set)inputShredding.get(key);
            if (shredSet.size() != 1 || !shredSet.contains(key)) continue;
            removeKeys.add(key);
        }
        i = removeKeys.iterator();
        while (i.hasNext()) {
            inputShredding.remove(i.next());
        }
        DISPATCHER.fireIterationCompleted(new IterationCompletionEvent(collectionStructure, inputShredding, this.workflowInstance, this.activeProcessor, inputMap, outputMap));
        return outputMap;
    }

    private void insertObjectInto(Object o, List l, int[] position, DataThing theThing) {
        List currentList = l;
        String oldLSID = theThing.getLSID(l);
        if (oldLSID != null) {
            theThing.getLSIDMap().remove(l);
        }
        for (int i = 0; i < position.length - 1; ++i) {
            int index = position[i];
            if (index < currentList.size()) {
                currentList = (List)currentList.get(index);
                continue;
            }
            int numberShort = index - currentList.size() + 1;
            for (int j = 0; j < numberShort; ++j) {
                currentList.add(new ArrayList());
            }
            currentList = (List)currentList.get(index);
        }
        int objectIndex = position[position.length - 1];
        try {
            currentList.add(objectIndex, o);
        }
        catch (IndexOutOfBoundsException ioobe) {
            currentList.add(o);
        }
        if (oldLSID != null) {
            theThing.setLSID(l, oldLSID);
        }
    }

    public ProcessorTask(String id, Flow flow, Processor p, LogLevel l, String userID, String userCtx) {
        super(id, flow);
        this.proc = p;
        this.logLevel = new LogLevel(l.getLevel());
        this.userID = userID;
        this.userCtx = userCtx;
        this.eventList = new ArrayList();
        super.setFailFlowOnTaskFailure(p.getCritical());
        this.schedule(p);
    }

    protected String getUserID() {
        return this.userID;
    }

    public ProcessEvent[] getEventList() {
        return this.eventList.toArray(new ProcessEvent[0]);
    }

    protected String getUserNamespaceContext() {
        return this.userCtx;
    }

    public Processor getProcessor() {
        return this.proc;
    }

    public Element getProvenance() {
        return new Element("NotImplementedHere", PROVENANCE_NAMESPACE);
    }

    public Element getFaultElement() {
        if (this.faultCausingException == null) {
            return null;
        }
        Element faultElement = new Element("failureDescription", PROVENANCE_NAMESPACE);
        String faultClass = this.faultCausingException.getClass().getName();
        String faultMessage = this.faultCausingException.getMessage();
        StringWriter sw = new StringWriter();
        this.faultCausingException.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        Element faultClassElement = new Element("exceptionClass", PROVENANCE_NAMESPACE);
        faultClassElement.setText(faultClass);
        faultElement.addContent((Content)faultClassElement);
        Element faultMessageElement = new Element("exceptionMessage", PROVENANCE_NAMESPACE);
        faultMessageElement.setText(faultMessage);
        faultElement.addContent((Content)faultMessageElement);
        Element faultTraceElement = new Element("exceptionTrace", PROVENANCE_NAMESPACE);
        faultTraceElement.setText(stackTrace);
        faultElement.addContent((Content)faultTraceElement);
        return faultElement;
    }

    static {
        String storageClassName = System.getProperty("taverna.datastore.class");
        if (storageClassName != null) {
            try {
                Class<?> c = Class.forName(storageClassName);
                STORE = (BaclavaDataService)c.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        PROVENANCE_NAMESPACE = provNS;
    }
}

