/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.taverna.enactor.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.CollectionConstructionEvent;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowEventDispatcher;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowInstanceImpl;
import uk.ac.soton.itinnovation.freefluo.core.event.RunEvent;
import uk.ac.soton.itinnovation.freefluo.core.flow.Flow;
import uk.ac.soton.itinnovation.freefluo.core.task.AbstractTask;
import uk.ac.soton.itinnovation.freefluo.core.task.Task;
import uk.ac.soton.itinnovation.freefluo.main.Engine;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;

public class PortTask
extends AbstractTask {
    private static Logger logger = Logger.getLogger((Class)PortTask.class);
    public static int IN = 0;
    public static int OUT = 1;
    private WorkflowInstance workflowInstance = null;
    private Port thePort;
    private DataThing theDataThing = null;

    public PortTask(String id, Flow flow, Port port) {
        super(id, flow);
        this.thePort = port;
    }

    public int type() {
        if (this.thePort instanceof InputPort) {
            return IN;
        }
        return OUT;
    }

    public Port getScuflPort() {
        return this.thePort;
    }

    public boolean dataAvailable() {
        return this.theDataThing != null;
    }

    public synchronized DataThing getData() {
        return this.theDataThing;
    }

    public synchronized void setData(DataThing newDataThing) {
        int i;
        int dataDimension;
        String portSyntaxType = this.thePort.getSyntacticType();
        String dataSyntaxType = newDataThing.getSyntacticType();
        String portSetType = portSyntaxType.split("\\'")[0];
        String dataSetType = dataSyntaxType.split("\\'")[0];
        int portDimension = portSetType.length() / 2;
        int encapsulationDifference = portDimension - (dataDimension = dataSetType.length() / 2);
        if (encapsulationDifference > 0) {
            String[] lsidWrapArray = new String[encapsulationDifference];
            ArrayList theDataObject = newDataThing.getDataObject();
            while (encapsulationDifference > 0) {
                --encapsulationDifference;
                ArrayList newList = new ArrayList();
                newList.add(theDataObject);
                theDataObject = newList;
            }
            this.theDataThing = new DataThing(theDataObject);
            this.theDataThing.copyMetadataFrom(newDataThing);
            this.theDataThing.fillLSIDValues();
            String originalLSID = newDataThing.getLSID(newDataThing.getDataObject());
            List l = (List)this.theDataThing.getDataObject();
            for (i = 0; i < lsidWrapArray.length; ++i) {
                lsidWrapArray[i] = this.theDataThing.getLSID(l);
                try {
                    l = (List)l.get(0);
                    continue;
                }
                catch (ClassCastException cce) {
                    break;
                }
            }
            WorkflowEventDispatcher.DISPATCHER.fireCollectionConstructed(new CollectionConstructionEvent(this.workflowInstance, lsidWrapArray, originalLSID));
        } else {
            this.theDataThing = newDataThing;
            this.theDataThing.fillLSIDValues();
        }
        if (this.getScuflPort() instanceof OutputPort) {
            PortTask childPortTask = null;
            Collection g = this.getChildren();
            Iterator i2 = g.iterator();
            while (i2.hasNext()) {
                Task task = (Task)i2.next();
                if (!(task instanceof PortTask)) continue;
                childPortTask = (PortTask)task;
                break;
            }
            if (childPortTask != null) {
                Port targetMetadataPort = childPortTask.getScuflPort();
                SemanticMarkup portMarkup = targetMetadataPort.getMetadata();
                String[] portMIMETypes = portMarkup.getMIMETypes();
                for (int i3 = 0; i3 < portMIMETypes.length; ++i3) {
                    this.theDataThing.getMetadata().addMIMEType(portMIMETypes[i3]);
                }
                this.theDataThing.getMetadata().setSemanticType(portMarkup.getSemanticType());
            }
            SemanticMarkup portMarkup = this.getScuflPort().getMetadata();
            String[] portMIMETypes = portMarkup.getMIMETypes();
            for (i = 0; i < portMIMETypes.length; ++i) {
                this.theDataThing.getMetadata().addMIMEType(portMIMETypes[i]);
            }
        }
        this.theDataThing.fillLSIDValues();
        if (this.getScuflPort().isSource() && ProcessorTask.STORE != null) {
            try {
                ProcessorTask.STORE.storeDataThing(this.theDataThing, true);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void handleDestroy() {
        this.thePort = null;
        this.theDataThing = null;
    }

    public void handleRun(RunEvent runEvent) {
        try {
            if (this.theDataThing == null) {
                this.fail("Task " + this.getTaskId() + " in flow " + this.getFlow().getFlowId() + " failed.  " + "No data for port " + this.thePort.getName() + ",please check its links");
            } else {
                Flow flow = this.getFlow();
                String flowID = flow.getFlowId();
                Engine e = flow.getEngine();
                this.workflowInstance = new WorkflowInstanceImpl(e, flowID);
                Iterator i = this.getChildren().iterator();
                while (i.hasNext()) {
                    Task task = (Task)i.next();
                    if (!(task instanceof PortTask)) continue;
                    PortTask childPortTask = (PortTask)task;
                    childPortTask.setData(this.theDataThing);
                }
                this.complete();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.fail("Task " + this.getTaskId() + " in flow " + this.getFlow().getFlowId() + " failed.  " + ex.getMessage());
        }
    }
}

