/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.mrc.hgmp.taverna.retsina;

import com.jgraph.JGraph;
import com.jgraph.event.GraphSelectionEvent;
import com.jgraph.event.GraphSelectionListener;
import com.jgraph.graph.BasicMarqueeHandler;
import com.jgraph.graph.CellView;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.GraphUndoManager;
import com.jgraph.graph.ParentMap;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.emboss.jemboss.gui.startup.ProgList;
import uk.ac.mrc.hgmp.taverna.retsina.IScuflNodeCreator;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraph;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphCell;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphModel;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflInputPortView;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflOutputPortView;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflPort;

public class ScuflGraphPanel
extends JPanel
implements GraphSelectionListener,
KeyListener,
ScuflUIComponent {
    protected ScuflGraph graph;
    protected GraphUndoManager undoManager;
    protected IScuflNodeCreator creatorDelegate;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    private ProgList progs;

    public ImageIcon getIcon() {
        return null;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Retsina application mode test");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new ScuflGraphPanel(null, null));
        frame.setSize(520, 390);
        frame.show();
    }

    public ScuflGraphPanel(IScuflNodeCreator delegate, ProgList progs) {
        this.creatorDelegate = delegate;
        this.progs = progs;
        this.setLayout(new BorderLayout());
        this.graph = new ScuflGraph((GraphModel)new ScuflGraphModel(), progs);
        this.graph.setMarqueeHandler(new ScuflMarqueeHandler());
        this.graph.setBackground(new Color(173, 173, 255));
        this.undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                ScuflGraphPanel.this.updateHistoryButtons();
            }
        };
        this.graph.getModel().addUndoableEditListener((UndoableEditListener)this.undoManager);
        this.graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        this.graph.addKeyListener(this);
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane((Component)((Object)this.graph)), "Center");
    }

    public String getXScufl() {
        return this.graph.getXScufl();
    }

    public void insertCell(Point point, String group, String name) {
        this.graph.insertCell(point, group, name);
    }

    public void insert(Point point) {
        ScuflGraphCell vertex = new ScuflGraphCell("Test");
        Map map = GraphConstants.createMap();
        Dimension size = new Dimension(100, 80);
        GraphConstants.setBounds((Map)map, (Rectangle)new Rectangle(point, size));
        GraphConstants.setBorderColor((Map)map, (Color)Color.black);
        GraphConstants.setBackground((Map)map, (Color)Color.gray);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        Hashtable<ScuflGraphCell, Map> attributes = new Hashtable<ScuflGraphCell, Map>();
        attributes.put(vertex, map);
        this.graph.getGraphLayoutCache().insert(new Object[]{vertex}, attributes, null, null, null);
    }

    public void group(Object[] cells) {
        cells = this.graph.getGraphLayoutCache().order(cells);
        if (cells != null && cells.length > 0) {
            int count = this.getCellCount(this.graph);
            DefaultGraphCell group = new DefaultGraphCell((Object)new Integer(count - 1));
            ParentMap map = new ParentMap();
            for (int i = 0; i < cells.length; ++i) {
                map.addEntry(cells[i], (Object)group);
            }
            this.graph.getGraphLayoutCache().insert(new Object[]{group}, null, null, map, null);
        }
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void ungroup(Object[] cells) {
        if (cells != null && cells.length > 0) {
            ArrayList<Object> groups = new ArrayList<Object>();
            ArrayList<Object> children = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isGroup(cells[i])) continue;
                groups.add(cells[i]);
                for (int j = 0; j < this.graph.getModel().getChildCount(cells[i]); ++j) {
                    Object child = this.graph.getModel().getChild(cells[i], j);
                    if (child instanceof Port) continue;
                    children.add(child);
                }
            }
            this.graph.getGraphLayoutCache().remove(groups.toArray());
            this.graph.setSelectionCells(children.toArray());
        }
    }

    public boolean isGroup(Object cell) {
        CellView view = this.graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        try {
            this.undoManager.undo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.undoManager.redo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo((Object)this.graph.getGraphLayoutCache()));
        this.redo.setEnabled(this.undoManager.canRedo((Object)this.graph.getGraphLayoutCache()));
    }

    public void valueChanged(GraphSelectionEvent e) {
        this.group.setEnabled(this.graph.getSelectionCount() > 1);
        boolean enabled = !this.graph.isSelectionEmpty();
        this.remove.setEnabled(enabled);
        this.ungroup.setEnabled(enabled);
        this.tofront.setEnabled(enabled);
        this.toback.setEnabled(enabled);
        this.copy.setEnabled(enabled);
        this.cut.setEnabled(enabled);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public JPopupMenu createPopupMenu(Point pt, final Object cell) {
        JPopupMenu menu = new JPopupMenu();
        if (cell != null) {
            menu.add(new AbstractAction("Edit"){

                public void actionPerformed(ActionEvent e) {
                    ScuflGraphPanel.this.graph.startEditingAtCell(cell);
                }
            });
        }
        if (!this.graph.isSelectionEmpty()) {
            menu.addSeparator();
            menu.add(new AbstractAction("Remove"){

                public void actionPerformed(ActionEvent e) {
                    ScuflGraphPanel.this.remove.actionPerformed(e);
                }
            });
        }
        return menu;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        URL insertUrl = this.getClass().getClassLoader().getResource("images/insert.gif");
        ImageIcon insertIcon = new ImageIcon(insertUrl);
        toolbar.add(new AbstractAction("", insertIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.insert(new Point(10, 10));
            }
        });
        URL connectUrl = this.getClass().getClassLoader().getResource("images/connecton.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        toolbar.add(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.graph.setPortsVisible(!ScuflGraphPanel.this.graph.isPortsVisible());
                URL connectUrl = ScuflGraphPanel.this.graph.isPortsVisible() ? this.getClass().getClassLoader().getResource("images/connecton.gif") : this.getClass().getClassLoader().getResource("images/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        toolbar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("images/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.undo();
            }
        };
        this.undo.setEnabled(false);
        toolbar.add(this.undo);
        URL redoUrl = this.getClass().getClassLoader().getResource("images/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.redo();
            }
        };
        this.redo.setEnabled(false);
        toolbar.add(this.redo);
        toolbar.addSeparator();
        this.graph.getTransferHandler();
        Action action = TransferHandler.getCopyAction();
        URL url = this.getClass().getClassLoader().getResource("images/copy.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.copy = new EventRedirector(action);
        toolbar.add(this.copy);
        this.graph.getTransferHandler();
        action = TransferHandler.getPasteAction();
        url = this.getClass().getClassLoader().getResource("images/paste.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.paste = new EventRedirector(action);
        toolbar.add(this.paste);
        this.graph.getTransferHandler();
        action = TransferHandler.getCutAction();
        url = this.getClass().getClassLoader().getResource("images/cut.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        this.cut = new EventRedirector(action);
        toolbar.add(this.cut);
        URL removeUrl = this.getClass().getClassLoader().getResource("images/delete.gif");
        ImageIcon removeIcon = new ImageIcon(removeUrl);
        this.remove = new AbstractAction("", removeIcon){

            public void actionPerformed(ActionEvent e) {
                if (!ScuflGraphPanel.this.graph.isSelectionEmpty()) {
                    Object[] cells = ScuflGraphPanel.this.graph.getSelectionCells();
                    cells = ScuflGraphPanel.this.graph.getDescendants(cells);
                    for (int i = 0; i < cells.length; ++i) {
                        if (!(cells[i] instanceof ScuflGraphCell)) continue;
                        ScuflGraphPanel.this.graph.destroyProcessor(((ScuflGraphCell)((Object)cells[i])).getScuflProcessor());
                    }
                    ScuflGraphPanel.this.graph.getModel().remove(cells);
                }
            }
        };
        this.remove.setEnabled(false);
        toolbar.add(this.remove);
        toolbar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("images/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        toolbar.add(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.graph.setScale(1.0);
            }
        });
        URL zoomInUrl = this.getClass().getClassLoader().getResource("images/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        toolbar.add(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.graph.setScale(2.0 * ScuflGraphPanel.this.graph.getScale());
            }
        });
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("images/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        toolbar.add(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.graph.setScale(ScuflGraphPanel.this.graph.getScale() / 2.0);
            }
        });
        toolbar.addSeparator();
        URL groupUrl = this.getClass().getClassLoader().getResource("images/group.gif");
        ImageIcon groupIcon = new ImageIcon(groupUrl);
        this.group = new AbstractAction("", groupIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.group(ScuflGraphPanel.this.graph.getSelectionCells());
            }
        };
        this.group.setEnabled(false);
        toolbar.add(this.group);
        URL ungroupUrl = this.getClass().getClassLoader().getResource("images/ungroup.gif");
        ImageIcon ungroupIcon = new ImageIcon(ungroupUrl);
        this.ungroup = new AbstractAction("", ungroupIcon){

            public void actionPerformed(ActionEvent e) {
                ScuflGraphPanel.this.ungroup(ScuflGraphPanel.this.graph.getSelectionCells());
            }
        };
        this.ungroup.setEnabled(false);
        toolbar.add(this.ungroup);
        toolbar.addSeparator();
        URL toFrontUrl = this.getClass().getClassLoader().getResource("images/tofront.gif");
        ImageIcon toFrontIcon = new ImageIcon(toFrontUrl);
        this.tofront = new AbstractAction("", toFrontIcon){

            public void actionPerformed(ActionEvent e) {
                if (!ScuflGraphPanel.this.graph.isSelectionEmpty()) {
                    ScuflGraphPanel.this.toFront(ScuflGraphPanel.this.graph.getSelectionCells());
                }
            }
        };
        this.tofront.setEnabled(false);
        toolbar.add(this.tofront);
        URL toBackUrl = this.getClass().getClassLoader().getResource("images/toback.gif");
        ImageIcon toBackIcon = new ImageIcon(toBackUrl);
        this.toback = new AbstractAction("", toBackIcon){

            public void actionPerformed(ActionEvent e) {
                if (!ScuflGraphPanel.this.graph.isSelectionEmpty()) {
                    ScuflGraphPanel.this.toBack(ScuflGraphPanel.this.graph.getSelectionCells());
                }
            }
        };
        this.toback.setEnabled(false);
        toolbar.add(this.toback);
        return toolbar;
    }

    public ScuflGraph getCurrentJGraph() {
        return this.graph;
    }

    public void attachToModel(ScuflModel scuflModel) {
        this.graph.attachToModel(scuflModel);
    }

    public void detachFromModel() {
    }

    public String getName() {
        return "Retsina";
    }

    protected class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a) {
            super("", (ImageIcon)a.getValue("SmallIcon"));
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(ScuflGraphPanel.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    public class ScuflMarqueeHandler
    extends BasicMarqueeHandler {
        protected Point start;
        protected Point current;
        protected PortView port;
        protected PortView firstPort;

        public boolean isForceMarqueeEvent(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return true;
            }
            this.port = this.getSourcePortAt(e.getPoint());
            if (this.port != null && ScuflGraphPanel.this.graph.isPortsVisible()) {
                return true;
            }
            return super.isForceMarqueeEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                Point loc = ScuflGraphPanel.this.graph.fromScreen(e.getPoint());
                Object cell = ScuflGraphPanel.this.graph.getFirstCellForLocation(loc.x, loc.y);
                JPopupMenu menu = ScuflGraphPanel.this.createPopupMenu(e.getPoint(), cell);
                menu.show((Component)((Object)ScuflGraphPanel.this.graph), e.getX(), e.getY());
            } else if (this.port != null && !e.isConsumed() && ScuflGraphPanel.this.graph.isPortsVisible()) {
                if (this.port instanceof ScuflOutputPortView) {
                    this.start = ScuflGraphPanel.this.graph.toScreen(((ScuflOutputPortView)this.port).getLocation(null));
                }
                this.firstPort = this.port;
                e.consume();
            } else {
                super.mousePressed(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null && !e.isConsumed() && !(this.firstPort instanceof ScuflInputPortView)) {
                Graphics g = ScuflGraphPanel.this.graph.getGraphics();
                this.paintConnector(Color.black, ScuflGraphPanel.this.graph.getBackground(), g);
                this.port = this.getTargetPortAt(e.getPoint());
                this.current = this.port != null ? ScuflGraphPanel.this.graph.toScreen(this.port.getLocation(null)) : ScuflGraphPanel.this.graph.snap(e.getPoint());
                this.paintConnector(ScuflGraphPanel.this.graph.getBackground(), Color.black, g);
                e.consume();
            }
            super.mouseDragged(e);
        }

        public PortView getSourcePortAt(Point point) {
            Point tmp = ScuflGraphPanel.this.graph.fromScreen(new Point(point));
            return ScuflGraphPanel.this.graph.getPortViewAt(tmp.x, tmp.y);
        }

        protected PortView getTargetPortAt(Point point) {
            return this.getSourcePortAt(point);
        }

        public void mouseReleased(MouseEvent e) {
            if (e != null && !e.isConsumed() && this.port != null && this.firstPort != null && this.firstPort != this.port) {
                ScuflGraphPanel.this.graph.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
                e.consume();
                ScuflGraphPanel.this.graph.addDataConstraint(((ScuflPort)((Object)this.firstPort.getCell())).getScuflPort(), ((ScuflPort)((Object)this.port.getCell())).getScuflPort());
            } else {
                ScuflGraphPanel.this.graph.repaint();
            }
            this.port = null;
            this.firstPort = null;
            this.current = null;
            this.start = null;
            super.mouseReleased(e);
        }

        public void mouseMoved(MouseEvent e) {
            PortView port = this.getTargetPortAt(e.getPoint());
            if (e != null && this.getSourcePortAt(e.getPoint()) != null && !e.isConsumed() && ScuflGraphPanel.this.graph.isPortsVisible() && !(port instanceof ScuflInputPortView)) {
                ScuflGraphPanel.this.graph.setCursor(new Cursor(12));
                e.consume();
            }
            super.mouseReleased(e);
        }

        protected void paintConnector(Color fg, Color bg, Graphics g) {
            g.setColor(fg);
            g.setXORMode(bg);
            if (this.firstPort != null && this.start != null && this.current != null) {
                g.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
            }
        }
    }
}

