/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.mrc.hgmp.taverna.retsina;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.WorkflowSubmissionException;
import org.embl.ebi.escience.scufl.enactor.implementation.FreefluoEnactorProxy;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.emboss.jemboss.JembossJarUtil;
import org.emboss.jemboss.gui.startup.ProgList;
import uk.ac.mrc.hgmp.taverna.retsina.ProgramSelectionPanel;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraph;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphCell;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphPanel;
import uk.ac.soton.itinnovation.freefluo.main.WorkflowState;

public class Retsina
extends JPanel
implements ScuflUIComponent {
    private ScuflGraphPanel graphPanel;
    private ScuflModel scuflModel;

    public ImageIcon getIcon() {
        return null;
    }

    public Retsina() {
        this(true);
    }

    public Retsina(boolean addMenuBar) {
        super(new BorderLayout());
        String wossname = null;
        try {
            JembossJarUtil jwoss = new JembossJarUtil("resources/wossname.jar");
            wossname = new String((byte[])jwoss.getElement("wossname.out"));
        }
        catch (Exception ex) {
            System.out.println("Failed to read wossname for menu construction");
        }
        JMenuBar progMenuBar = new JMenuBar();
        ProgList progs = new ProgList(wossname, progMenuBar);
        this.graphPanel = new ScuflGraphPanel(null, progs);
        ProgramSelectionPanel westPanel = new ProgramSelectionPanel(wossname, this.graphPanel, progs, progMenuBar);
        this.add((Component)this.graphPanel, "Center");
        this.add((Component)westPanel, "West");
        if (addMenuBar) {
            this.add((Component)this.createMenuBar(true), "North");
        }
    }

    public ScuflGraph getScuflGraph() {
        return this.graphPanel.getCurrentJGraph();
    }

    public void newWorkFlow() {
        ScuflGraph graph = this.getScuflGraph();
        Object[] cells = graph.getRoots();
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof ScuflGraphCell)) continue;
            ScuflGraphCell cell = (ScuflGraphCell)((Object)cells[i]);
            cell.removeAllChildren();
            graph.destroyProcessor(cell.getScuflProcessor());
        }
        graph.getModel().remove(cells);
        graph.clearScuflModel();
    }

    public void loadXScufl(String xscufl) {
        this.newWorkFlow();
        this.getScuflGraph().loadXScufl(xscufl);
    }

    public JMenuBar createMenuBar(final boolean closeMenu) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem newWorkFlow = new JMenuItem("New Workflow");
        newWorkFlow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Retsina.this.newWorkFlow();
            }
        });
        fileMenu.add(newWorkFlow);
        fileMenu.add(new JSeparator());
        JMenuItem loadExampleXScufl = new JMenuItem("Load XScufl Example");
        loadExampleXScufl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BufferedInputStream workflow = new BufferedInputStream(new FileInputStream("src/uk/ac/soton/itinnovation/taverna/enactor/broker/test/XScufl_example.xml"));
                    StringWriter sWriter = new StringWriter();
                    while (workflow.available() > 0) {
                        sWriter.write(workflow.read());
                    }
                    String xscufl = sWriter.toString();
                    Retsina.this.loadXScufl(xscufl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        fileMenu.add(loadExampleXScufl);
        JMenuItem loadXScufl = new JMenuItem("Load Workflow");
        loadXScufl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    System.setSecurityManager(null);
                    JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
                    System.setSecurityManager(sm);
                    int returnVal = fc.showOpenDialog(fc);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        BufferedInputStream workflow = new BufferedInputStream(new FileInputStream(file));
                        StringWriter sWriter = new StringWriter();
                        while (workflow.available() > 0) {
                            sWriter.write(workflow.read());
                        }
                        String xscufl = sWriter.toString();
                        Retsina.this.getScuflGraph();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        fileMenu.add(loadXScufl);
        JMenuItem saveXScufl = new JMenuItem("Save Workflow");
        saveXScufl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SecurityManager sm = System.getSecurityManager();
                System.setSecurityManager(null);
                JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
                System.setSecurityManager(sm);
                int returnVal = fc.showSaveDialog(fc);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        FileWriter out = new FileWriter(file);
                        out.write(Retsina.this.getScuflGraph().getXScufl());
                        out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        });
        fileMenu.add(saveXScufl);
        fileMenu.add(new JSeparator());
        JMenuItem fileRunScufl = new JMenuItem("Run workflow");
        fileRunScufl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Retsina.this.submitWorkFlow();
            }
        });
        fileMenu.add(fileRunScufl);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = null;
        fileMenuExit = closeMenu ? new JMenuItem("Close") : new JMenuItem("Exit");
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (closeMenu) {
                    if (Retsina.this.getParent().getParent().getParent().getParent().getParent().getParent() instanceof JInternalFrame) {
                        ((JInternalFrame)Retsina.this.getParent().getParent().getParent().getParent().getParent().getParent()).dispose();
                    } else {
                        Retsina.this.setVisible(false);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        JMenuItem viewXScufl = new JMenuItem("Display XScufl");
        viewXScufl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("XScufl");
                JTextPane xscufl = new JTextPane();
                JPanel pscroll = new JPanel(new BorderLayout());
                JScrollPane rscroll = new JScrollPane(pscroll);
                rscroll.getViewport().setBackground(Color.white);
                xscufl.setText(Retsina.this.getScuflGraph().getXScufl());
                xscufl.setEditable(false);
                pscroll.add(xscufl);
                JOptionPane jop = new JOptionPane();
                rscroll.setPreferredSize(new Dimension(400, 180));
                xscufl.setCaretPosition(0);
                f.getContentPane().add(rscroll);
                f.pack();
                f.setVisible(true);
            }
        });
        viewMenu.add(viewXScufl);
        menuBar.add(viewMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem aboutMenu = new JMenuItem("About");
        aboutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URL inURL = this.getClass().getClassLoader().getResource("resources/retsina.html");
                JTextPane about = new JTextPane();
                JPanel pscroll = new JPanel(new BorderLayout());
                JScrollPane rscroll = new JScrollPane(pscroll);
                rscroll.getViewport().setBackground(Color.white);
                try {
                    about.setPage(inURL);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                about.setEditable(false);
                pscroll.add(about);
                JOptionPane jop = new JOptionPane();
                rscroll.setPreferredSize(new Dimension(400, 180));
                JOptionPane.showMessageDialog(null, rscroll, "About ", -1);
            }
        });
        helpMenu.add(aboutMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void submitWorkFlow() {
        ScuflGraph graph = this.getScuflGraph();
        try {
            FreefluoEnactorProxy enactorProxy = new FreefluoEnactorProxy();
            WorkflowInstance workflowInstance = null;
            try {
                String input = graph.getDataSet().getDataSetString();
                System.out.println(input);
                Map inputMap = graph.getDataSet().getData();
                workflowInstance = enactorProxy.compileWorkflow(graph.getScuflModel(), inputMap, null);
            }
            catch (WorkflowSubmissionException e) {
                e.printStackTrace();
                return;
            }
            boolean stop = false;
            String status = "UNKNOWN";
            while (!stop) {
                status = workflowInstance.getStatus();
                if (status.equals(WorkflowState.COMPLETE_STATE) || status.equals(WorkflowState.FAILED_STATE)) {
                    stop = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {}
            }
            if (status.equals(WorkflowState.FAILED_STATE)) {
                System.out.println("Error message: " + workflowInstance.getErrorMessage());
            }
            System.out.println("Emboss Workflow has finished with status: " + status);
            System.out.println("Output:\n\n" + workflowInstance.getOutputXMLString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void attachToModel(ScuflModel scuflModel) {
        this.scuflModel = scuflModel;
        this.graphPanel.attachToModel(scuflModel);
    }

    public void detachFromModel() {
    }

    public String getName() {
        return "Retsina";
    }
}

