/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.mrc.hgmp.taverna.retsina;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.emboss.jemboss.gui.startup.ProgList;
import uk.ac.mrc.hgmp.taverna.retsina.ProgramJList;
import uk.ac.mrc.hgmp.taverna.retsina.ScuflGraphPanel;

public class ProgramSelectionPanel
extends JPanel {
    private ScuflGraphPanel graphPanel;
    private ProgList progs;

    public ProgramSelectionPanel(String wossname, ScuflGraphPanel graphPanel, ProgList progs, JMenuBar progMenuBar) {
        super(new BorderLayout());
        this.graphPanel = graphPanel;
        this.progs = progs;
        int npG = progs.getNumPrimaryGroups();
        final int numProgs = progs.getNumProgs();
        final String[] allAcd = progs.getProgsList();
        progMenuBar.setLayout(new GridLayout(npG, 1));
        final ProgramJList progList = new ProgramJList(allAcd);
        JScrollPane scrollPane = new JScrollPane(progList);
        Box alphaPane = new Box(1);
        Box alphaTextPane = new Box(0);
        alphaPane.add(Box.createRigidArea(new Dimension(0, 10)));
        alphaTextPane.add(new JLabel("GoTo:"));
        alphaTextPane.add(Box.createRigidArea(new Dimension(5, 0)));
        final JTextField alphaTextPaneEntry = new JTextField(12);
        alphaTextPaneEntry.setMaximumSize(new Dimension(100, 20));
        alphaTextPaneEntry.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.updateScroll();
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateScroll();
            }

            public void changedUpdate(DocumentEvent e) {
            }

            public void updateScroll() {
                for (int k = 0; k < numProgs; ++k) {
                    if (!allAcd[k].startsWith(alphaTextPaneEntry.getText())) continue;
                    progList.ensureIndexIsVisible(k);
                    progList.setSelectionBackground(Color.cyan);
                    progList.setSelectedIndex(k);
                    break;
                }
            }
        });
        alphaTextPaneEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = progList.getSelectedIndex();
                System.out.println(allAcd[index]);
            }
        });
        alphaTextPane.add(alphaTextPaneEntry);
        alphaPane.add(alphaTextPane);
        alphaPane.add(scrollPane);
        this.add((Component)progMenuBar, "North");
        this.add((Component)alphaPane, "Center");
        Dimension d = this.getMinimumSize();
        d = new Dimension((int)d.getWidth() - 10, (int)d.getHeight());
        this.setPreferredSize(d);
        this.createProgramMenuListener(allAcd, numProgs);
        this.createProgramListListener(progList, allAcd);
        this.createTextEntryListener(progList, allAcd, alphaTextPaneEntry);
    }

    private void createTextEntryListener(final JList progList, final String[] allAcd, JTextField alphaTextPaneEntry) {
        alphaTextPaneEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = progList.getSelectedIndex();
                String app = allAcd[index];
                String group = ProgramSelectionPanel.this.progs.getProgramGroup(app).toLowerCase().replace(':', '_').replace(' ', '_');
                ProgramSelectionPanel.this.graphPanel.insertCell(new Point(0, 0), group, app);
            }
        });
    }

    private void createProgramListListener(JList progList, final String[] allAcd) {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JList source = (JList)e.getSource();
                source.setSelectionBackground(Color.cyan);
                int index = source.getSelectedIndex();
                String app = allAcd[index];
                String group = ProgramSelectionPanel.this.progs.getProgramGroup(app).toLowerCase().replace(':', '_').replace(' ', '_');
                ProgramSelectionPanel.this.graphPanel.insertCell(new Point(0, 0), group, app);
            }
        };
        progList.addMouseListener(mouseListener);
    }

    private void createProgramMenuListener(final String[] allAcd, final int numProgs) {
        JMenuItem[] mi = new JMenuItem[numProgs];
        mi = this.progs.getMenuItems();
        int nm = this.progs.getNumberMenuItems();
        for (int i = 0; i < nm; ++i) {
            mi[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JMenuItem source = (JMenuItem)e.getSource();
                    String p = source.getText();
                    int ind = p.indexOf(" ");
                    p = p.substring(0, ind).trim();
                    for (int k = 0; k < numProgs; ++k) {
                        if (!p.equalsIgnoreCase(allAcd[k])) continue;
                        String app = allAcd[k];
                        String group = ProgramSelectionPanel.this.progs.getProgramGroup(app).toLowerCase().replace(':', '_').replace(' ', '_');
                        ProgramSelectionPanel.this.graphPanel.insertCell(new Point(0, 0), group, app);
                        System.out.println();
                        break;
                    }
                }
            });
        }
    }
}

