/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.workflow;

import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.XScufl;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scufl.view.XScuflView;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessor;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessorFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class WorkflowXMLHandler
implements XMLHandler {
    public Element elementForProcessor(Processor p) {
        WorkflowProcessor wp = (WorkflowProcessor)p;
        Element spec = new Element("workflow", XScufl.XScuflNS);
        if (wp.getDefinitionURL() != null) {
            Element definition = new Element("xscufllocation", XScufl.XScuflNS);
            spec.addContent((Content)definition);
            definition.setText(wp.getDefinitionURL());
        } else {
            XScuflView view = new XScuflView(wp.getInternalModel());
            Document doc = view.getDocument();
            spec.addContent((Content)doc.detachRootElement());
            wp.getInternalModel().removeListener(view);
        }
        return spec;
    }

    public Element elementForFactory(ProcessorFactory pf) {
        WorkflowProcessorFactory wpf = (WorkflowProcessorFactory)pf;
        Element spec = new Element("workflow", XScufl.XScuflNS);
        Element definition = new Element("xscufllocation", XScufl.XScuflNS);
        spec.addContent((Content)definition);
        definition.setText(wpf.getDefinitionURL());
        return spec;
    }

    public ProcessorFactory getFactory(Element specElement) {
        String definitionURL = specElement.getChild("xscufllocation", XScufl.XScuflNS).getTextTrim();
        return new WorkflowProcessorFactory(definitionURL);
    }

    public Processor loadProcessorFromXML(Element processorNode, ScuflModel model, String name) throws ProcessorCreationException, DuplicateProcessorNameException, XScuflFormatException {
        Element workflowProcessor = processorNode.getChild("workflow", XScufl.XScuflNS);
        Element locationElement = workflowProcessor.getChild("xscufllocation", XScufl.XScuflNS);
        if (locationElement != null) {
            String definitionURL = workflowProcessor.getChild("xscufllocation", XScufl.XScuflNS).getTextTrim();
            return new WorkflowProcessor(model, name, definitionURL);
        }
        Element scuflElement = workflowProcessor.getChild("scufl", XScufl.XScuflNS);
        if (scuflElement == null) {
            throw new ProcessorCreationException("Neither XScufl location nor literal inlined workflow defined for nested workflow processor, failing!");
        }
        return new WorkflowProcessor(model, name, scuflElement);
    }
}

