/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.workflow;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.EnactorProxy;
import org.embl.ebi.escience.scufl.enactor.UserContext;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.WorkflowSubmissionException;
import org.embl.ebi.escience.scufl.enactor.implementation.FreefluoEnactorProxy;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowInstanceImpl;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessor;
import uk.ac.soton.itinnovation.freefluo.event.WorkflowStateChangedEvent;
import uk.ac.soton.itinnovation.freefluo.event.WorkflowStateListener;
import uk.ac.soton.itinnovation.freefluo.main.WorkflowState;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class WorkflowTask
implements ProcessorTaskWorker {
    private static EnactorProxy defaultEnactor = new FreefluoEnactorProxy();
    private static Logger logger = Logger.getLogger((Class)WorkflowTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private static final long WAITTIME = 10000L;
    private String subWorkflowID = null;
    private WorkflowInstance workflowInstance = null;
    private Processor proc;
    private WorkflowState workflowState;

    public WorkflowTask(Processor p) {
        this.proc = p;
    }

    public Map execute(Map inputMap, ProcessorTask parentTask) throws TaskExecutionException {
        WorkflowProcessor theProcessor = (WorkflowProcessor)this.proc;
        ScuflModel theNestedModel = theProcessor.getInternalModel();
        try {
            WorkflowInstance parentInstance = parentTask.workflowInstance;
            UserContext context = parentInstance.getUserContext();
            this.workflowInstance = defaultEnactor.compileWorkflow(theNestedModel, inputMap, context);
        }
        catch (WorkflowSubmissionException e) {
            String msg = "Error executing workflow task.  Error compiling the nested workflow.";
            logger.error((Object)msg, (Throwable)e);
            throw new TaskExecutionException(msg);
        }
        try {
            final Thread taskThread = Thread.currentThread();
            ((WorkflowInstanceImpl)this.workflowInstance).addWorkflowStateListener(new WorkflowStateListener(){

                public void workflowStateChanged(WorkflowStateChangedEvent event) {
                    WorkflowState state = event.getWorkflowState();
                    if (state.isFinal()) {
                        taskThread.interrupt();
                    }
                }
            });
            this.workflowInstance.run();
        }
        catch (Exception e) {
            String msg = "Nested workflow failed in task, error message was: " + e.getMessage();
            logger.error((Object)msg, (Throwable)e);
            throw new TaskExecutionException(msg);
        }
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ie) {
            WorkflowState workflowState = WorkflowState.getState((String)this.workflowInstance.getStatus());
            if (workflowState.equals(WorkflowState.COMPLETE)) {
                return this.workflowInstance.getOutput();
            }
            if (workflowState.equals(WorkflowState.FAILED)) {
                throw new TaskExecutionException("Nested workflow failed in task, error message was : " + this.workflowInstance.getErrorMessage());
            }
            if (workflowState.equals(WorkflowState.CANCELLED)) {
                return new HashMap();
            }
            throw new TaskExecutionException("Unknown flow state in task, failing.");
        }
    }
}

