/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.workflow;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scuflui.workbench.Scavenger;
import org.embl.ebi.escience.scuflui.workbench.ScavengerCreationException;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessorFactory;

public class WorkflowScavenger
extends Scavenger {
    public WorkflowScavenger(String definitionURL) throws ScavengerCreationException {
        super(new WorkflowProcessorFactory(definitionURL));
        ScuflModel model = new ScuflModel();
        try {
            model.setOffline(true);
            XScuflParser.populate(new URL(definitionURL).openStream(), model, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Processor[] processors = model.getProcessors();
        for (int i = 0; i < processors.length; ++i) {
            String tagName = ProcessorHelper.getTagNameForClassName(processors[i].getClass().getName());
            XMLHandler xh = ProcessorHelper.getXMLHandlerForTagName(tagName);
            System.out.println(tagName + ":" + processors[i].getName());
            if (xh == null) continue;
            ProcessorFactory pf = xh.getFactory(xh.elementForProcessor(processors[i]));
            this.add(new DefaultMutableTreeNode(pf));
        }
    }
}

