/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.soaplab;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;

public class SoaplabProcessor
extends Processor
implements Serializable {
    private URL endpoint = null;

    public String getResourceHost() {
        return this.endpoint.getHost();
    }

    public String getCategory() {
        String[] app = this.endpoint.getPath().split("::");
        if (app.length == 1) {
            return "";
        }
        String[] pathbits = app[0].split("/");
        return pathbits[pathbits.length - 1];
    }

    public String getServicePath() {
        String[] pathbits = this.endpoint.getPath().split("/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pathbits.length - 1; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(pathbits[i]);
        }
        return sb.toString();
    }

    public String getAppName() {
        String[] app = this.endpoint.getPath().split("::");
        if (app.length == 1) {
            return "";
        }
        return app[1];
    }

    public SoaplabProcessor(ScuflModel model, String name, String endpoint) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        try {
            String firstPart = endpoint.split("\\?")[0];
            this.setEndpoint(firstPart);
        }
        catch (MalformedURLException mue) {
            throw new ProcessorCreationException(name + ": The supplied endpoint url was \n   malformed, endpoint was specified as '" + endpoint + "'");
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("Soaplab URL", this.getEndpoint().toString());
        return props;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setEndpoint(String specifier) throws MalformedURLException, ProcessorCreationException {
        URL new_endpoint = new URL(specifier);
        if (this.endpoint != null) {
            if (this.endpoint.equals(new_endpoint)) return;
            this.fireModelEvent(new ScuflModelEvent(this, "Service endpoint changed to '" + specifier + "'"));
        } else {
            this.fireModelEvent(new ScuflModelEvent(this, "Service endpoint set to '" + specifier + "'"));
        }
        this.endpoint = new_endpoint;
        try {
            if (this.isOffline()) return;
            this.generatePorts();
            this.getDescriptionText();
            return;
        }
        catch (PortCreationException pce) {
            throw new ProcessorCreationException(this.getName() + ": Exception when trying to create ports\n   from Soaplab endpoint : " + pce.getMessage());
        }
        catch (DuplicatePortNameException dpne) {
            throw new ProcessorCreationException(this.getName() + ": Exception when trying to create ports\n   from Soaplab endpoint : " + dpne.getMessage());
        }
    }

    public void getDescriptionText() throws ProcessorCreationException {
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.endpoint.toString());
            call.setOperationName(new QName("getAnalysisType"));
            Map info = (Map)call.invoke(new Object[0]);
            String description = (String)info.get("description");
            if (description != null) {
                this.setDescription(description);
            }
        }
        catch (ServiceException se) {
            throw new ProcessorCreationException(this.getName() + ": Unable to create a new call to connect to\n   soaplab, error was : " + se.getMessage());
        }
        catch (RemoteException re) {
            throw new ProcessorCreationException(this.getName() + ": Unable to call the get description method\n   for XScufl processor " + this.getName() + "\nendpoint : " + this.endpoint.toString() + "\n   Remote exception message " + re.getMessage());
        }
    }

    public void generatePorts() throws ProcessorCreationException, PortCreationException, DuplicatePortNameException {
        this.ports = new ArrayList();
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.endpoint.toString());
            call.setOperationName(new QName("getInputSpec"));
            Map[] inputs = (Map[])call.invoke(new Object[0]);
            for (int i = 0; i < inputs.length; ++i) {
                Map input_spec = inputs[i];
                String input_name = (String)input_spec.get("name");
                String input_type = ((String)input_spec.get("type")).toLowerCase();
                InputPort new_port = new InputPort(this, input_name);
                if (input_type.equals("string")) {
                    new_port.setSyntacticType("'text/plain'");
                } else if (input_type.equals("string[]")) {
                    new_port.setSyntacticType("l('text/plain')");
                } else if (input_type.equals("byte[]")) {
                    new_port.setSyntacticType("'application/octet-stream'");
                } else if (input_type.equals("byte[][]")) {
                    new_port.setSyntacticType("l('application/octet-stream')");
                }
                this.addPort(new_port);
            }
            call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.endpoint.toString());
            call.setOperationName(new QName("getResultSpec"));
            Map[] results = (Map[])call.invoke(new Object[0]);
            for (int i = 0; i < results.length; ++i) {
                Map output_spec = results[i];
                String output_name = (String)output_spec.get("name");
                String output_type = ((String)output_spec.get("type")).toLowerCase();
                if (output_name.equalsIgnoreCase("detailed_status")) continue;
                OutputPort new_port = new OutputPort(this, output_name);
                if (output_type.equals("string")) {
                    new_port.setSyntacticType("'text/plain'");
                } else if (output_type.equals("string[]")) {
                    new_port.setSyntacticType("l('text/plain')");
                } else if (output_type.equals("byte[]")) {
                    new_port.setSyntacticType("'application/octet-stream'");
                } else if (output_type.equals("byte[][]")) {
                    new_port.setSyntacticType("l('application/octet-stream')");
                }
                this.addPort(new_port);
            }
        }
        catch (ServiceException se) {
            throw new ProcessorCreationException(this.getName() + ": Unable to create a new call to connect\n   to soaplab, error was : " + se.getMessage());
        }
        catch (RemoteException re) {
            throw new ProcessorCreationException(this.getName() + ": Unable to call the get spec method for\n   endpoint : " + this.endpoint.toString() + "\n   Remote exception message " + re.getMessage());
        }
        catch (NullPointerException npe) {
            this.generatePorts();
        }
    }

    public URL getEndpoint() {
        return this.endpoint;
    }
}

