/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.biomoby;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflworkers.biomoby.CreateMobyData;
import org.embl.ebi.escience.scuflworkers.java.LocalWorker;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class ExtractMobyData
implements LocalWorker {
    Namespace mobyNS = CreateMobyData.mobyNS;

    public String[] inputNames() {
        return new String[]{"mobydata"};
    }

    public String[] inputTypes() {
        return new String[]{"'text/xml'"};
    }

    public String[] outputNames() {
        return new String[]{"namespace", "id", "value", "type"};
    }

    public String[] outputTypes() {
        return new String[]{"'text/plain'", "'text/plain'", "'text/plain'", "'text/plain'"};
    }

    public Map execute(Map inputs) throws TaskExecutionException {
        String namespaceValue;
        Element mobyDataElement;
        Element mobyElement;
        System.out.println("Entering moby parse stage");
        if (!inputs.containsKey("mobydata")) {
            throw new TaskExecutionException("Moby input data is mandatory");
        }
        String mobyDataString = (String)((DataThing)inputs.get("mobydata")).getDataObject();
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build((Reader)new StringReader(mobyDataString));
            mobyElement = document.getRootElement();
        }
        catch (JDOMException jde) {
            throw new TaskExecutionException("Unable to parse biomoby data, check the XML! " + jde.getMessage());
        }
        catch (IOException ioe) {
            throw new TaskExecutionException("Unable to parse biomoby data, check the XML! " + ioe.getMessage());
        }
        try {
            Element mobySimple = mobyElement.getChild("mobyContent", this.mobyNS).getChild("mobyData", this.mobyNS).getChild("Simple", this.mobyNS);
            mobyDataElement = (Element)mobySimple.getChildren().get(0);
        }
        catch (NullPointerException npe) {
            throw new TaskExecutionException("Unexpected structure within moby data, check the input XML.");
        }
        HashMap<String, DataThing> results = new HashMap<String, DataThing>();
        String idValue = mobyDataElement.getAttributeValue("id");
        if (idValue == null) {
            idValue = mobyDataElement.getAttributeValue("id", this.mobyNS, "");
        }
        if ((namespaceValue = mobyDataElement.getAttributeValue("namespace")) == null) {
            namespaceValue = mobyDataElement.getAttributeValue("namespace", this.mobyNS, "");
        }
        results.put("id", new DataThing(idValue));
        results.put("namespace", new DataThing(namespaceValue));
        results.put("value", new DataThing(mobyDataElement.getTextTrim()));
        results.put("type", new DataThing(mobyDataElement.getName()));
        System.out.println("Returning parsed results");
        return results;
    }
}

