/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.biomoby;

import java.util.HashMap;
import java.util.Map;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflworkers.java.LocalWorker;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class CreateMobyData
implements LocalWorker {
    static Namespace mobyNS = Namespace.getNamespace((String)"moby", (String)"http://www.biomoby.org/moby");

    public String[] inputNames() {
        return new String[]{"namespace", "id", "stringvalue", "floatvalue", "intvalue"};
    }

    public String[] inputTypes() {
        return new String[]{"'text/plain'", "'text/plain'", "'text/plain'", "'text/plain'", "'text/plain'"};
    }

    public String[] outputNames() {
        return new String[]{"mobydata"};
    }

    public String[] outputTypes() {
        return new String[]{"'text/xml'"};
    }

    public Map execute(Map inputs) throws TaskExecutionException {
        String idValue;
        String namespaceValue;
        boolean hasString = inputs.containsKey("stringvalue");
        boolean hasFloat = inputs.containsKey("floatvalue");
        boolean hasInt = inputs.containsKey("intvalue");
        try {
            namespaceValue = (String)((DataThing)inputs.get("namespace")).getDataObject();
            idValue = (String)((DataThing)inputs.get("id")).getDataObject();
        }
        catch (Exception ex) {
            throw new TaskExecutionException("Both ID and namespace must be specified to build the moby object");
        }
        Element mobyElement = new Element("MOBY", mobyNS);
        Element mobyContent = new Element("mobyContent", mobyNS);
        mobyElement.addContent((Content)mobyContent);
        Element mobyData = new Element("mobyData", mobyNS);
        mobyData.setAttribute("queryID", "a1", mobyNS);
        mobyContent.addContent((Content)mobyData);
        Element mobySimple = new Element("Simple", mobyNS);
        mobySimple.setAttribute("articleName", "", mobyNS);
        mobyData.addContent((Content)mobySimple);
        Element dataElement = null;
        if (!(hasString || hasFloat || hasInt)) {
            dataElement = new Element("Object", mobyNS);
        } else if (hasString && !hasFloat && !hasInt) {
            dataElement = new Element("String", mobyNS);
            String stringValue = (String)((DataThing)inputs.get("stringvalue")).getDataObject();
            dataElement.setText(stringValue);
        } else if (hasFloat && !hasInt && !hasString) {
            dataElement = new Element("Float", mobyNS);
            try {
                String floatValue = (String)((DataThing)inputs.get("floatvalue")).getDataObject();
                Float.parseFloat(floatValue);
                dataElement.setText(floatValue);
            }
            catch (NumberFormatException nfe) {
                throw new TaskExecutionException("Float value specified but not parsable as a floating point numeral");
            }
        } else if (hasInt && !hasFloat && !hasString) {
            dataElement = new Element("Integer", mobyNS);
            try {
                String intValue = (String)((DataThing)inputs.get("intvalue")).getDataObject();
                Integer.parseInt(intValue);
                dataElement.setText(intValue);
            }
            catch (NumberFormatException nfe) {
                throw new TaskExecutionException("Int value specified but not parsable as an integer");
            }
        } else {
            throw new TaskExecutionException("To construct a moby data object you must specify at most one of string, int or float values.");
        }
        dataElement.setAttribute("namespace", namespaceValue, mobyNS);
        dataElement.setAttribute("id", idValue, mobyNS);
        mobySimple.addContent((Content)dataElement);
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        String mobyOutputString = xo.outputString(new Document(mobyElement));
        HashMap<String, DataThing> results = new HashMap<String, DataThing>();
        results.put("mobydata", new DataThing(mobyOutputString));
        return results;
    }
}

