/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.biomoby;

import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.XScufl;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyProcessor;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyProcessorFactory;
import org.jdom.Content;
import org.jdom.Element;

public class BiomobyXMLHandler
implements XMLHandler {
    static final String MOBY_SPEC = "biomobywsdl";
    static final String MOBY_ENDPOINT = "mobyEndpoint";
    static final String SERVICE_NAME = "serviceName";
    static final String AUTHORITY_NAME = "authorityName";

    public Element elementForProcessor(Processor p) {
        BiomobyProcessor bmproc = (BiomobyProcessor)p;
        return this.getElement(bmproc.getMobyEndpoint(), bmproc.getServiceName(), bmproc.getAuthorityName());
    }

    public Element elementForFactory(ProcessorFactory pf) {
        BiomobyProcessorFactory bpf = (BiomobyProcessorFactory)pf;
        return this.getElement(bpf.getMobyEndpoint(), bpf.getServiceName(), bpf.getAuthorityName());
    }

    private Element getElement(String mobyEndpoint, String serviceName, String authorityName) {
        Element spec = new Element(MOBY_SPEC, XScufl.XScuflNS);
        Element mobyEndpointElement = new Element(MOBY_ENDPOINT, XScufl.XScuflNS);
        mobyEndpointElement.setText(mobyEndpoint);
        spec.addContent((Content)mobyEndpointElement);
        Element serviceNameElement = new Element(SERVICE_NAME, XScufl.XScuflNS);
        serviceNameElement.setText(serviceName);
        spec.addContent((Content)serviceNameElement);
        Element authorityNameElement = new Element(AUTHORITY_NAME, XScufl.XScuflNS);
        authorityNameElement.setText(authorityName);
        spec.addContent((Content)authorityNameElement);
        return spec;
    }

    public ProcessorFactory getFactory(Element specElement) {
        Element mobyEndpointElement = specElement.getChild(MOBY_ENDPOINT, XScufl.XScuflNS);
        String mobyEndpoint = mobyEndpointElement.getTextTrim();
        Element serviceNameElement = specElement.getChild(SERVICE_NAME, XScufl.XScuflNS);
        String serviceName = serviceNameElement.getTextTrim();
        Element authorityNameElement = specElement.getChild(AUTHORITY_NAME, XScufl.XScuflNS);
        String authorityName = authorityNameElement.getTextTrim();
        return new BiomobyProcessorFactory(mobyEndpoint, authorityName, serviceName);
    }

    public Processor loadProcessorFromXML(Element processorNode, ScuflModel model, String processorName) throws ProcessorCreationException, DuplicateProcessorNameException, XScuflFormatException {
        Element biomoby = processorNode.getChild(MOBY_SPEC, XScufl.XScuflNS);
        Element mobyEndpointElement = biomoby.getChild(MOBY_ENDPOINT, XScufl.XScuflNS);
        String mobyEndpoint = mobyEndpointElement.getTextTrim();
        Element serviceNameElement = biomoby.getChild(SERVICE_NAME, XScufl.XScuflNS);
        String serviceName = serviceNameElement.getTextTrim();
        Element authorityNameElement = biomoby.getChild(AUTHORITY_NAME, XScufl.XScuflNS);
        String authorityName = authorityNameElement.getTextTrim();
        return new BiomobyProcessor(model, processorName, authorityName, serviceName, mobyEndpoint);
    }
}

