/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.biomoby;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.biomoby.client.CentralImpl;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyProcessor;
import org.embl.ebi.escience.scuflworkers.biomoby.CreateMobyData;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class BiomobyTask
implements ProcessorTaskWorker {
    private static Logger logger = Logger.getLogger((Class)BiomobyTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private Processor proc;
    Namespace mobyNS = CreateMobyData.mobyNS;

    public BiomobyTask(Processor p) {
        this.proc = p;
    }

    public Map execute(Map inputMap, ProcessorTask parentTask) throws TaskExecutionException {
        try {
            DataThing inputThing = (DataThing)inputMap.get("input");
            InputPort myInput = this.proc.getInputPorts()[0];
            String inputType = myInput.getSyntacticType();
            String inputXML = null;
            if (inputType.equals("'text/xml'")) {
                inputXML = (String)inputThing.getDataObject();
            } else {
                List simpleInputs = (List)inputThing.getDataObject();
                Element root = new Element("MOBY", this.mobyNS);
                Element content = new Element("mobyContent", this.mobyNS);
                root.addContent((Content)content);
                Element data = new Element("mobyData", this.mobyNS);
                data.setAttribute("queryID", "a1", this.mobyNS);
                content.addContent((Content)data);
                Element collectionElement = new Element("Collection", this.mobyNS);
                collectionElement.setAttribute("articleName", "", this.mobyNS);
                Iterator i = simpleInputs.iterator();
                while (i.hasNext()) {
                    Element el = (Element)i.next();
                    Element mobyDataElement = el.getChild("mobyContent", this.mobyNS).getChild("mobyData", this.mobyNS);
                    Element simpleElement = (Element)mobyDataElement.getChildren().get(0);
                    collectionElement.addContent(simpleElement.detach());
                }
                XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
                inputXML = xo.outputString(new Document(root));
            }
            String methodName = ((BiomobyProcessor)this.proc).getServiceName();
            String serviceEndpoint = ((BiomobyProcessor)this.proc).getEndpoint().toExternalForm();
            String outputXML = new CentralImpl(serviceEndpoint, "http://biomoby.org/").call(methodName, inputXML);
            HashMap<String, DataThing> outputMap = new HashMap<String, DataThing>();
            OutputPort myOutput = this.proc.getOutputPorts()[0];
            String outputType = myOutput.getSyntacticType();
            if (outputType.equals("'text/xml'")) {
                outputMap.put("output", new DataThing(outputXML));
            } else {
                ArrayList<String> outputList = new ArrayList<String>();
                SAXBuilder saxBuilder = new SAXBuilder();
                Document doc = saxBuilder.build(new InputSource(new StringReader(outputXML)));
                Element mobyElement = doc.getRootElement();
                Element collectionElement = mobyElement.getChild("mobyContent", this.mobyNS).getChild("mobyData", this.mobyNS).getChild("Collection", this.mobyNS);
                ArrayList simpleElements = new ArrayList(collectionElement.getChildren());
                Iterator i = simpleElements.iterator();
                while (i.hasNext()) {
                    Element simpleElement = (Element)i.next();
                    Element newRoot = new Element("MOBY", this.mobyNS);
                    Element newMobyContent = new Element("mobyContent", this.mobyNS);
                    newRoot.addContent((Content)newMobyContent);
                    Element newMobyData = new Element("mobyData", this.mobyNS);
                    newMobyData.setAttribute("queryID", "a1", this.mobyNS);
                    newMobyContent.addContent((Content)newMobyData);
                    newMobyData.addContent(simpleElement.detach());
                    XMLOutputter xo = new XMLOutputter();
                    String outputItemString = xo.outputString(new Document(newRoot));
                    outputList.add(outputItemString);
                }
                outputMap.put("output", new DataThing(outputList));
            }
            return outputMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Error invoking biomoby service for biomoby", (Throwable)ex);
            TaskExecutionException tee = new TaskExecutionException("Task failed due to problem invoking biomoby service");
            tee.initCause(ex);
            throw tee;
        }
    }
}

