/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.beanshell;

import bsh.Interpreter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflworkers.ProcessorTaskWorker;
import org.embl.ebi.escience.scuflworkers.beanshell.BeanshellProcessor;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.TaskExecutionException;

public class BeanshellTask
implements ProcessorTaskWorker {
    private static Logger logger = Logger.getLogger((Class)BeanshellTask.class);
    private static final int INVOCATION_TIMEOUT = 0;
    private Processor proc;
    private Interpreter interpreter = new Interpreter();

    public BeanshellTask(Processor p) {
        this.proc = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map execute(Map workflowInputMap, ProcessorTask parentTask) throws TaskExecutionException {
        try {
            BeanshellProcessor theProcessor = (BeanshellProcessor)this.proc;
            String script = theProcessor.getScript();
            HashMap<String, DataThing> outputMap = new HashMap<String, DataThing>();
            OutputPort[] outputPorts = theProcessor.getOutputPorts();
            Interpreter interpreter = this.interpreter;
            synchronized (interpreter) {
                Iterator iinput = workflowInputMap.keySet().iterator();
                while (iinput.hasNext()) {
                    String inputname = (String)iinput.next();
                    DataThing inputdt = (DataThing)workflowInputMap.get(inputname);
                    this.interpreter.set(inputname, inputdt.getDataObject());
                }
                Object result = this.interpreter.eval(script);
                for (int ioutput = 0; ioutput < outputPorts.length; ++ioutput) {
                    Object value = this.interpreter.get(outputPorts[ioutput].getName());
                    if (value != null) {
                        outputMap.put(outputPorts[ioutput].getName(), new DataThing(value));
                    }
                    this.interpreter.unset(outputPorts[ioutput].getName());
                }
                iinput = workflowInputMap.keySet().iterator();
                while (iinput.hasNext()) {
                    String inputname = (String)iinput.next();
                    this.interpreter.unset(inputname);
                }
            }
            return outputMap;
        }
        catch (Exception ex) {
            throw new TaskExecutionException("Error running beanshell script: " + ex);
        }
    }
}

