/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers.beanshell;

import java.io.Serializable;
import java.util.Properties;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;

public class BeanshellProcessor
extends Processor
implements Serializable {
    private String theScript = "";

    public BeanshellProcessor(ScuflModel model, String name, String script, String[] inputs, String[] outputs) throws ProcessorCreationException, DuplicateProcessorNameException {
        super(model, name);
        try {
            Port p;
            int i;
            this.theScript = script;
            for (i = 0; i < inputs.length; ++i) {
                p = new InputPort(this, inputs[i]);
                p.setSyntacticType("'text/plain'");
                this.addPort(p);
            }
            for (i = 0; i < outputs.length; ++i) {
                p = new OutputPort(this, outputs[i]);
                p.setSyntacticType("'text/plain'");
                this.addPort(p);
            }
        }
        catch (DuplicatePortNameException dpne) {
            throw new ProcessorCreationException("The supplied specification for the beanshell processor '" + name + "' contained a duplicate port '" + dpne.getMessage() + "'");
        }
        catch (PortCreationException pce) {
            throw new ProcessorCreationException("An error occured whilst generating ports for the beanshell processor " + pce.getMessage());
        }
    }

    public void setScript(String theScript) {
        this.theScript = theScript != null ? theScript : "";
        this.fireModelEvent(new ScuflModelEvent(this, "Script modified"));
    }

    public String getScript() {
        return this.theScript;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("Script", "See configurator for more information");
        return props;
    }
}

