/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflworkers;

import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.XMLHandler;
import org.jdom.Content;
import org.jdom.Element;

public abstract class ProcessorFactory {
    public final Processor createProcessor(String name, ScuflModel model) throws ProcessorCreationException, DuplicateProcessorNameException {
        Element wrapperElement = new Element("wrapper");
        wrapperElement.addContent((Content)this.getXMLFragment());
        try {
            Processor newProcessor = ProcessorHelper.loadProcessorFromXML(wrapperElement, model, name);
            if (newProcessor == null) {
                throw new ProcessorCreationException("Failed to find processor for: " + wrapperElement);
            }
            if (model != null) {
                model.addProcessor(newProcessor);
            }
            return newProcessor;
        }
        catch (XScuflFormatException xfe) {
            throw new ProcessorCreationException("Invalid internal XML representation!", xfe);
        }
    }

    public abstract String getProcessorDescription();

    public abstract Class getProcessorClass();

    public final Element getXMLFragment() {
        String tagName = ProcessorHelper.getTagNameForClassName(this.getProcessorClass().getName());
        XMLHandler xh = (XMLHandler)ProcessorHelper.xmlHandlerForTagName.get(tagName);
        return xh.elementForFactory(this);
    }
}

