/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.workbench;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.TavernaReleaseInfo;
import org.embl.ebi.escience.scufl.enactor.WorkflowSubmissionException;
import org.embl.ebi.escience.scufl.enactor.implementation.FreefluoEnactorProxy;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scufl.semantics.RDFSParser;
import org.embl.ebi.escience.scuflui.AdvancedModelExplorer;
import org.embl.ebi.escience.scuflui.DataThingConstructionPanel;
import org.embl.ebi.escience.scuflui.EnactorInvocation;
import org.embl.ebi.escience.scuflui.ScavengerTreePanel;
import org.embl.ebi.escience.scuflui.ScuflDiagramPanel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.UIComponentRegistry;
import org.embl.ebi.escience.scuflui.UIUtils;
import org.embl.ebi.escience.scuflui.workbench.FileDrop;
import org.embl.ebi.escience.scuflui.workbench.ScrollableDesktopPane;
import org.embl.ebi.escience.scuflui.workbench.SplashScreen;

public class Workbench
extends JFrame {
    public static ImageIcon background;
    public static Workbench workbench;
    public JDesktopPane desktop;
    public ScuflModel model;

    public static void main(String[] args) {
        new SplashScreen(8000);
        try {
            URL ontologyURL = System.getProperty("taverna.ontology.location") != null ? new URL(System.getProperty("taverna.ontology.location")) : ClassLoader.getSystemResource("org/embl/ebi/escience/scufl/semantics/mygrid-reasoned-small.rdfs");
            RDFSParser.loadRDFSDocument(ontologyURL.openStream(), "Types");
        }
        catch (Exception ex) {
            System.out.println("Failed to load ontology data! " + ex.getMessage());
            ex.printStackTrace();
        }
        final Workbench workbench = new Workbench();
        if (System.getProperty("taverna.workbench.useinternalframes") != null) {
            UIUtils.DEFAULT_FRAME_CREATOR = new UIUtils.FrameCreator(){

                public void createFrame(ScuflModel targetModel, ScuflUIComponent targetComponent, int posX, int posY, int sizeX, int sizeY) {
                    GenericUIComponentFrame thing = new GenericUIComponentFrame(targetModel, targetComponent);
                    thing.setSize(sizeX, sizeY);
                    thing.setLocation(posX, posY);
                    workbench.desktop.add(thing);
                    thing.moveToFront();
                    thing.setVisible(true);
                }

                class GenericUIComponentFrame
                extends JInternalFrame {
                    ScuflUIComponent component;

                    public GenericUIComponentFrame(ScuflModel model, ScuflUIComponent component) {
                        super(component.getName(), true, true, true, true);
                        this.component = component;
                        JScrollPane pane = new JScrollPane((JComponent)((Object)component));
                        if (component.getIcon() != null) {
                            this.setFrameIcon(component.getIcon());
                        }
                        this.getContentPane().add(pane);
                        component.attachToModel(model);
                        this.addInternalFrameListener(new InternalFrameAdapter(this, this){
                            private final /* synthetic */ 1 val$this$0;
                            private final /* synthetic */ GenericUIComponentFrame this$1;
                            {
                                this.this$1 = this$1;
                                this.val$this$0 = val$this$0;
                            }

                            public void internalFrameClosing(InternalFrameEvent e) {
                                this.this$1.component.detachFromModel();
                            }
                        });
                    }
                }
            };
        } else {
            workbench.setBounds(0, 0, 450, 105);
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                File inputFile = new File(args[i]);
                XScuflParser.populate(inputFile.toURL().openStream(), workbench.model, null);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        workbench.setVisible(true);
        workbench.toFront();
        UIUtils.createFrame(workbench.model, new ScuflDiagramPanel(), 20, 440, 500, 400);
        UIUtils.createFrame(workbench.model, new AdvancedModelExplorer(), 20, 120, 500, 300);
        UIUtils.createFrame(workbench.model, new ScavengerTreePanel(), 540, 120, 300, 720);
    }

    public Workbench() {
        super("Scufl Workbench v" + TavernaReleaseInfo.getVersion() + ", built " + TavernaReleaseInfo.getBuildDate().toString());
        workbench = this;
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 880;
        int height = 1010;
        if (screenSize.width - inset * 2 < width) {
            width = screenSize.width - inset * 2;
        }
        if (screenSize.height - inset * 2 < height) {
            height = screenSize.height - inset * 2;
        }
        this.setBounds(inset, inset, width, height);
        this.model = new ScuflModel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (System.getProperty("taverna.scrollDesktop") == null) {
            this.desktop = new JDesktopPane();
            this.setContentPane(this.desktop);
        } else {
            this.desktop = new ScrollableDesktopPane();
            this.setContentPane(new JScrollPane(this.desktop));
        }
        this.setJMenuBar(this.createMenuBar());
        if (background != null) {
            JLabel bgLabel = new JLabel(background);
            bgLabel.setBounds(0, 0, background.getIconWidth(), background.getIconHeight());
            this.desktop.add((Component)bgLabel, new Integer(Integer.MIN_VALUE));
        }
        new FileDrop(this.desktop, new FileDrop.Listener(){

            public void filesDropped(File[] filesDropped) {
                File[] files = filesDropped;
                if (files.length == 1) {
                    new Thread(this, files){
                        private final /* synthetic */ File[] val$files;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$files = val$files;
                        }

                        public void run() {
                            try {
                                XScuflParser.populate(this.val$files[0].toURL().openStream(), 4.access$000(this.this$1).model, null);
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(null, "Problem opening XScufl from file : \n\n" + ex.getMessage() + "\n\nTo load this workflow try setting offline mode, this will allow you to load and remove any defunct operations.", "Exception!", 0);
                            }
                        }
                    }.start();
                } else {
                    int i = 0;
                    while (i < files.length) {
                        int j = i++;
                        new Thread(this, files, j){
                            private final /* synthetic */ File[] val$files;
                            private final /* synthetic */ int val$j;
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$files = val$files;
                                this.val$j = val$j;
                            }

                            public void run() {
                                try {
                                    XScuflParser.populate(this.val$files[this.val$j].toURL().openStream(), 4.access$000(this.this$1).model, "file" + this.val$j);
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(null, "Problem opening XScufl from file : \n" + ex.getMessage(), "Exception!", 0);
                                }
                            }
                        }.start();
                    }
                }
            }

            static /* synthetic */ Workbench access$000(4 x0) {
                return x0.Workbench.this;
            }
        });
    }

    JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu windowMenu = new JMenu("Tools and Workflow Invocation");
        UIComponentRegistry registry = UIComponentRegistry.instance();
        Iterator i = registry.getComponents().keySet().iterator();
        while (i.hasNext()) {
            String itemName = (String)i.next();
            try {
                final Class<?> itemClass = Class.forName((String)registry.getComponents().get(itemName));
                ImageIcon itemIcon = (ImageIcon)registry.getIcons().get(itemName);
                JMenuItem menuItem = null;
                menuItem = itemIcon == null ? new JMenuItem(itemName) : new JMenuItem(itemName, itemIcon);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        try {
                            ScuflUIComponent thing = (ScuflUIComponent)itemClass.newInstance();
                            UIUtils.createFrame(Workbench.this.model, thing, 100, 100, 400, 400);
                        }
                        catch (InstantiationException ie) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                });
                windowMenu.add(menuItem);
            }
            catch (Exception ex) {}
        }
        JMenuItem thingBuilder = new JMenuItem("Run workflow", ScuflIcons.runIcon);
        thingBuilder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScuflModel theModel = Workbench.this.model;
                if (theModel.isOffline()) {
                    JOptionPane.showMessageDialog(null, "Workflow is currently offline, cannot be invoked.\nDeselect the 'offline' checkbox in the AME to set \nonline mode in order to run this workflow.", "Offline, cannot invoke", 0);
                } else if (theModel.getWorkflowSourcePorts().length != 0) {
                    DataThingConstructionPanel thing = new DataThingConstructionPanel(this, theModel){
                        private final /* synthetic */ ScuflModel val$theModel;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$theModel = val$theModel;
                        }

                        public void launchEnactorDisplay(Map inputObject) {
                            try {
                                UIUtils.createFrame(this.val$theModel, new EnactorInvocation(FreefluoEnactorProxy.getInstance(), this.val$theModel, inputObject), 100, 100, 600, 400);
                            }
                            catch (WorkflowSubmissionException wse) {
                                JOptionPane.showMessageDialog(null, "Problem invoking workflow engine : \n" + wse.getMessage(), "Exception!", 0);
                            }
                        }
                    };
                    UIUtils.createFrame(theModel, thing, 100, 100, 600, 400);
                } else {
                    try {
                        UIUtils.createFrame(theModel, new EnactorInvocation(FreefluoEnactorProxy.getInstance(), theModel, new HashMap()), 100, 100, 600, 400);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        windowMenu.addSeparator();
        windowMenu.add(thingBuilder);
        menuBar.add(windowMenu);
        return menuBar;
    }

    static {
        workbench = null;
        try {
            Class<?> c = Class.forName("org.embl.ebi.escience.scuflui.workbench.Workbench");
            try {
                background = new ImageIcon(c.getResource("background.png"));
            }
            catch (Exception e) {
                background = null;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        UIComponentRegistry.instance();
        ResourceBundle rb = ResourceBundle.getBundle("mygrid");
        Properties sysProps = System.getProperties();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = rb.getString(key);
            sysProps.put(key, value);
        }
    }
}

