/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.workbench;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class ScrollableDesktopPane
extends JDesktopPane {
    protected Hashtable listeners = new Hashtable();

    private Dimension preferredSizeOfAllFrames() {
        JInternalFrame[] array = this.getAllFrames();
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < array.length; ++i) {
            int y;
            if (!array[i].isVisible()) continue;
            int x = array[i].getX() + array[i].getWidth();
            if (x > maxX) {
                maxX = x;
            }
            if ((y = array[i].getY() + array[i].getHeight()) <= maxY) continue;
            maxY = y;
        }
        return new Dimension(maxX, maxY);
    }

    public void paint(Graphics g) {
        this.setPreferredSize(this.preferredSizeOfAllFrames());
        super.paint(g);
    }

    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.registerListener(comp);
    }

    public Component add(Component comp) {
        this.registerListener(comp);
        return super.add(comp);
    }

    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        this.registerListener(comp);
    }

    public Component add(String name, Component comp) {
        this.registerListener(comp);
        return super.add(name, comp);
    }

    public void registerListener(Component comp) {
        ComponentListener listener = new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                ScrollableDesktopPane.this.revalidate();
                ScrollableDesktopPane.this.repaint();
            }

            public void componentMoved(ComponentEvent e) {
                this.componentResized(e);
            }

            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }

            public void componentHidden(ComponentEvent e) {
                this.componentResized(e);
            }
        };
        this.listeners.put(comp, listener);
        comp.addComponentListener(listener);
        this.revalidate();
    }

    public void remove(Component comp) {
        super.remove(comp);
        this.validate();
        comp.removeComponentListener((ComponentListener)this.listeners.get(comp));
    }
}

