/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.workbench;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.workbench.ScavengerCreationException;
import org.embl.ebi.escience.scuflui.workbench.ScavengerTree;
import org.embl.ebi.escience.scuflui.workbench.WebScavenger;
import org.embl.ebi.escience.scuflworkers.ProcessorFactory;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.ScavengerHelper;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessorFactory;

public class ScavengerTreePopupHandler
extends MouseAdapter {
    private static Logger LOG = Logger.getLogger((Class)ProcessorFactory.class);
    private ScavengerTree scavenger;

    public ScavengerTreePopupHandler(ScavengerTree theTree) {
        this.scavenger = theTree;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doEvent(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doEvent(e);
        }
    }

    void doEvent(MouseEvent e) {
        DefaultMutableTreeNode node;
        Object scuflObject;
        TreePath path = this.scavenger.getPathForLocation(e.getX(), e.getY());
        if (path != null && (scuflObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) != null) {
            if (scuflObject instanceof ProcessorFactory && this.scavenger.model != null) {
                final ProcessorFactory pf = (ProcessorFactory)scuflObject;
                JPopupMenu menu = new JPopupMenu();
                JMenuItem add = new JMenuItem("Add to model", ScuflIcons.importIcon);
                menu.add(add);
                JMenuItem addWithName = new JMenuItem("Add to model with name...", ScuflIcons.importIcon);
                menu.add(addWithName);
                Processor[] processors = this.scavenger.model.getProcessors();
                if (processors.length > 0) {
                    JMenu processorList = new JMenu("Add as alternate to...");
                    for (int i = 0; i < processors.length; ++i) {
                        JMenuItem processorItem = new JMenuItem(processors[i].getName(), ProcessorHelper.getPreferredIcon(processors[i]));
                        processorList.add(processorItem);
                        final Processor theProcessor = processors[i];
                        processorItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ae) {
                                try {
                                    int numberOfAlternates = theProcessor.getAlternatesArray().length;
                                    AlternateProcessor alternate = new AlternateProcessor(pf.createProcessor("alternate" + (numberOfAlternates + 1), null));
                                    theProcessor.addAlternate(alternate);
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(null, "Problem creating alternate : \n" + ex.getMessage(), "Exception!", 0);
                                }
                            }
                        });
                    }
                    menu.add(processorList);
                }
                if (scuflObject instanceof WorkflowProcessorFactory) {
                    JMenuItem imp = new JMenuItem("Import workflow...", ScuflIcons.webIcon);
                    final String definitionURL = ((WorkflowProcessorFactory)scuflObject).getDefinitionURL();
                    imp.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            try {
                                String prefix = (String)JOptionPane.showInputDialog(null, "Optional name prefix?", "Prefix", 3, null, null, "");
                                if (prefix != null) {
                                    if (prefix.equals("")) {
                                        prefix = null;
                                    }
                                    XScuflParser.populate(new URL(definitionURL).openStream(), ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.model, prefix);
                                }
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(null, "Problem opening XScufl from web : \n" + ex.getMessage(), "Exception!", 0);
                            }
                        }
                    });
                    menu.add(imp);
                }
                addWithName.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        String name = (String)JOptionPane.showInputDialog(null, "Name for the new processor?", "Name required", 3, null, null, "");
                        if (name != null) {
                            try {
                                pf.createProcessor(name, ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.model);
                            }
                            catch (ProcessorCreationException pce) {
                                JOptionPane.showMessageDialog(null, "Processor creation exception : \n" + pce.getMessage(), "Exception!", 0);
                            }
                            catch (DuplicateProcessorNameException dpne) {
                                JOptionPane.showMessageDialog(null, "Duplicate name : \n" + dpne.getMessage(), "Exception!", 0);
                            }
                        }
                    }
                });
                add.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        String defaultName = node.toString();
                        String validName = ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.model.getValidProcessorName(defaultName);
                        try {
                            pf.createProcessor(validName, ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.model);
                        }
                        catch (ProcessorCreationException pce) {
                            LOG.error((Object)"Problen crating processor", (Throwable)pce);
                            JOptionPane.showMessageDialog(null, "Processor creation exception : \n" + pce.getMessage(), "Exception!", 0);
                        }
                        catch (DuplicateProcessorNameException dpne) {
                            LOG.error((Object)"Problen crating processor", (Throwable)dpne);
                            JOptionPane.showMessageDialog(null, "Duplicate name : \n" + dpne.getMessage(), "Exception!", 0);
                        }
                    }
                });
                menu.show(this.scavenger, e.getX(), e.getY());
            } else if (scuflObject instanceof String) {
                String choice = (String)scuflObject;
                if (choice.equals("Available Processors")) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.setLabel("Create new scavenger");
                    Iterator i = ProcessorHelper.getScavengerToTagNames().keySet().iterator();
                    while (i.hasNext()) {
                        String scavengerClassName = (String)i.next();
                        ImageIcon scavengerIcon = ProcessorHelper.getIconForTagName((String)ProcessorHelper.getScavengerToTagNames().get(scavengerClassName));
                        try {
                            Class<?> scavengerHelperClass = Class.forName(scavengerClassName);
                            ScavengerHelper sh = (ScavengerHelper)scavengerHelperClass.newInstance();
                            String scavengerDescription = sh.getScavengerDescription();
                            JMenuItem scavengerMenuItem = new JMenuItem(scavengerDescription, scavengerIcon);
                            scavengerMenuItem.addActionListener(sh.getListener(this.scavenger));
                            menu.add(scavengerMenuItem);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    JMenuItem addWeb = new JMenuItem("Collect scavengers from web...", ScuflIcons.webIcon);
                    menu.addSeparator();
                    menu.add(addWeb);
                    addWeb.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            String rootURL = (String)JOptionPane.showInputDialog(null, "Address of the web page to crawl from?", "Web root location", 3, null, null, "http://cvs.mygrid.org.uk/scufl/");
                            if (rootURL != null) {
                                try {
                                    ScavengerTreePopupHandler.this.scavenger.addScavenger(new WebScavenger(rootURL, ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.treeModel));
                                }
                                catch (ScavengerCreationException sce) {
                                    JOptionPane.showMessageDialog(null, "Unable to create scavenger!\n" + sce.getMessage(), "Exception!", 0);
                                }
                            }
                        }
                    });
                    JMenuItem collect = new JMenuItem("Collect scavengers from model", ScuflIcons.importIcon);
                    menu.add(collect);
                    collect.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            try {
                                ScavengerTreePopupHandler.this.scavenger.addScavengersFromModel();
                            }
                            catch (ScavengerCreationException sce) {
                                JOptionPane.showMessageDialog(null, "Unable to import scavengers!\n" + sce.getMessage(), "Exception!", 0);
                            }
                        }
                    });
                    menu.addSeparator();
                    JMenuItem showAllNodes = new JMenuItem("Expand all");
                    menu.add(showAllNodes);
                    showAllNodes.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            ScavengerTreePopupHandler.this.scavenger.setAllNodesExpanded();
                        }
                    });
                    menu.show(this.scavenger, e.getX(), e.getY());
                } else if (!choice.equals("Internal Services") && !choice.equals("Local Java widgets")) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem remove = new JMenuItem("Remove from tree", ScuflIcons.deleteIcon);
                    final String scavengerName = choice;
                    remove.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            DefaultTreeModel treeModel = ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.treeModel;
                            DefaultMutableTreeNode treeNode = node;
                            treeModel.removeNodeFromParent(treeNode);
                            ((ScavengerTreePopupHandler)ScavengerTreePopupHandler.this).scavenger.scavengerList.remove(scavengerName);
                        }
                    });
                    menu.add(remove);
                    menu.show(this.scavenger, e.getX(), e.getY());
                }
            }
        }
    }
}

