/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.embl.ebi.escience.scuflui.results.ResultTable;
import org.embl.ebi.escience.scuflui.results.ResultTableCell;
import org.embl.ebi.escience.scuflui.results.ResultTableColumn;
import org.embl.ebi.escience.scuflui.results.ResultTableModel;

public class ResultTableUI
extends BasicTableUI {
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax) {
        if (this.table.getShowHorizontalLines()) {
            g.setColor(this.table.getGridColor());
            int rowHeight = this.table.getRowHeight();
            int tableWidth = g.getClipBounds().width;
            int x = g.getClipBounds().x;
            int y = rowHeight * rMin;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(x, (y += rowHeight) - 1, tableWidth - 1, y - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        for (int column = cMin; column <= cMax; ++column) {
            ResultTableColumn aColumn = ((ResultTableModel)this.table.getModel()).getColumn(column);
            Iterator cells = aColumn.getCellsBetween(rMin, rMax).iterator();
            while (cells.hasNext()) {
                ResultTableCell cell = (ResultTableCell)cells.next();
                Rectangle cellRect = ((ResultTable)this.table).getCellRect(cell, column, false);
                this.paintCell(g, cellRect, cell.startRow, column);
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        Component component = this.table.prepareRenderer(renderer, row, column);
        this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }
}

