/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scuflui.renderers.RendererException;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;
import org.embl.ebi.escience.scuflui.results.ResultTable;
import org.embl.ebi.escience.scuflui.results.ResultThing;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;

public class ResultTablePanel
extends JPanel
implements ResultTable.TableSelectionListener {
    ResultTable resultTable;
    private JSplitPane split;

    public ResultTablePanel(ScuflModel model, WorkflowInstance workflowInstance) {
        this.initComponents(model, workflowInstance);
    }

    private void initComponents(ScuflModel model, WorkflowInstance workflowInstance) {
        this.setLayout(new BorderLayout());
        this.resultTable = new ResultTable(model, workflowInstance);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.resultTable);
        pane.setPreferredSize(new Dimension(0, 0));
        this.split = new JSplitPane();
        this.split.setLeftComponent(pane);
        this.split.setRightComponent(null);
        this.split.setResizeWeight(0.8);
        this.add((Component)this.split, "Center");
        this.resultTable.addTableSelectionListener(this);
    }

    public void valueChanged(ResultTable table, ResultThing thing) {
        System.out.println("Cell: " + this.resultTable.getSelectedColumn() + "," + this.resultTable.getSelectedRow());
        if (thing != null) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new GridLayout(2, 1));
            JLabel otherLabel = new JLabel("This is the output of");
            JLabel outputLabel = new JLabel(thing.getSource().toString());
            outputLabel.setIcon(ProcessorHelper.getPreferredIcon(thing.getSource().getProcessor()));
            textPanel.add(otherLabel);
            textPanel.add(outputLabel);
            panel.add((Component)textPanel, "North");
            RendererSPI renderer = RendererRegistry.instance().getRenderer(thing.getDataThing());
            try {
                JScrollPane scroll = new JScrollPane(renderer.getComponent(RendererRegistry.instance(), thing.getDataThing()));
                scroll.setPreferredSize(new Dimension(0, 0));
                panel.add((Component)scroll, "Center");
            }
            catch (RendererException e1) {
                e1.printStackTrace();
            }
            this.split.setRightComponent(panel);
        } else {
            this.split.setRightComponent(null);
        }
    }
}

