/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scuflui.results.ResultSource;
import org.embl.ebi.escience.scuflui.results.ResultTableCell;
import org.embl.ebi.escience.scuflui.results.ResultTableColumn;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ResultTableModel
implements TableModel {
    private ScuflModel model;
    WorkflowInstance instance;
    HashMap provenance;
    private int rowCount;
    private ResultSource[] sources = null;
    private boolean condenseColumns = true;
    private Collection tableListeners = new ArrayList();
    private ResultTableColumn[] columns;

    public ResultTableModel(ScuflModel model, WorkflowInstance instance) {
        this.model = model;
        this.instance = instance;
        this.createColumns();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return ResultTableCell.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].getValue(rowIndex);
    }

    public ResultTableColumn getColumn(int column) {
        return this.columns[column];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex].toString();
    }

    public void addTableModelListener(TableModelListener l) {
        this.tableListeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.tableListeners.remove(l);
    }

    private ResultSource createSource(DataConstraint link) {
        Map[] maps;
        DataThing thing = null;
        Processor processor = link.getSource().getProcessor();
        if (processor.getName().equals("SCUFL_INTERNAL_SOURCEPORTS")) {
            try {
                maps = this.instance.getIntermediateResultsForProcessor(link.getSink().getProcessor().getName());
                Map outputs = maps[0];
                thing = (DataThing)outputs.get(link.getSink().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                maps = this.instance.getIntermediateResultsForProcessor(processor.getName());
                Map outputs = maps[1];
                thing = (DataThing)outputs.get(link.getSource().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ResultSource source = new ResultSource(link.getSource(), thing);
        source.populateResults(this.provenance);
        return source;
    }

    private void createSources() {
        if (this.sources == null) {
            ResultSource source;
            try {
                this.provenance = this.parseProvenance(this.instance.getProvenanceXMLString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<Port, ResultSource> sourceMap = new HashMap<Port, ResultSource>();
            DataConstraint[] links = this.model.getDataConstraints();
            for (int index = 0; index < links.length; ++index) {
                source = (ResultSource)sourceMap.get(links[index].getSource());
                if (source == null) {
                    source = this.createSource(links[index]);
                    sourceMap.put(links[index].getSource(), source);
                }
                source.addOutputProcessor(links[index].getSink().getProcessor());
            }
            Iterator sourceIterator = sourceMap.values().iterator();
            while (sourceIterator.hasNext()) {
                source = (ResultSource)sourceIterator.next();
                Iterator processorIterator = source.outputProcessors.iterator();
                while (processorIterator.hasNext()) {
                    Processor processor = (Processor)processorIterator.next();
                    OutputPort[] ports = processor.getBoundOutputPorts();
                    for (int index = 0; index < ports.length; ++index) {
                        ResultSource outputSource = (ResultSource)sourceMap.get(ports[index]);
                        if (outputSource == null) continue;
                        source.addOutput(outputSource);
                        outputSource.addInput(source);
                    }
                }
            }
            this.sources = new ResultSource[sourceMap.size()];
            sourceMap.values().toArray(this.sources);
            Arrays.sort(this.sources, new Comparator(){

                public boolean equals(Object obj) {
                    return false;
                }

                public int compare(Object o1, Object o2) {
                    return ((ResultSource)o1).getDepth() - ((ResultSource)o2).getDepth();
                }
            });
        }
    }

    private void createColumns() {
        this.createSources();
        ArrayList<ResultTableColumn> columnList = new ArrayList<ResultTableColumn>();
        int depth = -1;
        ResultTableColumn column = null;
        for (int index = 0; index < this.sources.length; ++index) {
            ResultTableColumn newColumn;
            if (this.condenseColumns) {
                if (this.sources[index].getDepth() != depth) {
                    newColumn = new ResultTableColumn();
                    newColumn.previousColumn = column;
                    if (column != null) {
                        column.nextColumn = newColumn;
                    }
                    column = newColumn;
                    depth = this.sources[index].getDepth();
                    columnList.add(column);
                }
            } else {
                newColumn = new ResultTableColumn();
                newColumn.previousColumn = column;
                column.nextColumn = newColumn;
                column = newColumn;
                columnList.add(column);
            }
            column.addSource(this.sources[index]);
        }
        this.columns = new ResultTableColumn[columnList.size()];
        columnList.toArray(this.columns);
        this.update();
    }

    private HashMap parseProvenance(String provenanceXML) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(provenanceXML));
        Element root = doc.getRootElement();
        System.out.println(root.getName());
        HashMap<String, ArrayList<String>> provenance = new HashMap<String, ArrayList<String>>();
        for (int index = 0; index < root.getChildren().size(); ++index) {
            Element item = (Element)root.getChildren().get(index);
            String rdf = item.getText();
            rdf = rdf.replaceAll("&lt;", "<");
            rdf = rdf.replaceAll("&amp;", "&");
            int tvpIndex = (rdf = rdf.replaceAll("&gt;", ">")).indexOf("tavp:createdFrom");
            if (tvpIndex != -1) {
                rdf = rdf.substring(0, tvpIndex + 16) + " xmlns:tavp=\"http://org.embl.ebi.escience/taverna-provenance\" " + rdf.substring(tvpIndex + 16);
            }
            Document itemDoc = builder.build((Reader)new StringReader(rdf));
            Element description = itemDoc.getRootElement();
            String aboutLSID = description.getAttributeValue("about", description.getNamespace("rdf"));
            for (int inner = 0; inner < description.getChildren().size(); ++inner) {
                Element relationship = (Element)description.getChildren().get(inner);
                if (!relationship.getName().equals("createdFrom")) continue;
                ArrayList<String> createdList = (ArrayList<String>)provenance.get(aboutLSID);
                if (createdList == null) {
                    createdList = new ArrayList<String>();
                }
                createdList.add(relationship.getAttributeValue("resource", description.getNamespace("rdf")));
                provenance.put(aboutLSID, createdList);
            }
        }
        return provenance;
    }

    public void update() {
        try {
            int row = 0;
            for (int index = this.columns.length - 1; index > 0; --index) {
                System.out.println("Getting data for " + this.columns[index]);
                row = this.columns[index].fillColumn(row);
            }
            this.rowCount = row;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getAllInputs(DataThing thing, Collection inputLSIDs) {
        ArrayList moreInputs;
        if (thing != null && (moreInputs = (ArrayList)this.provenance.get(thing.getLSID(thing.getDataObject()))) != null) {
            inputLSIDs.addAll(moreInputs);
        }
    }

    DataThing findThing(DataThing thing, String lsid, Collection inputLSIDs) {
        if (lsid.equals(thing.getLSID(thing.getDataObject()))) {
            this.getAllInputs(thing, inputLSIDs);
            return thing;
        }
        if (thing.getDataObject() instanceof List) {
            Iterator children = thing.childIterator();
            while (children.hasNext()) {
                DataThing child = (DataThing)children.next();
                DataThing result = this.findThing(child, lsid, inputLSIDs);
                if (result == null) continue;
                this.getAllInputs(thing, inputLSIDs);
                return result;
            }
        }
        return null;
    }
}

