/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.results.ResultSource;
import org.embl.ebi.escience.scuflui.results.ResultTableCell;
import org.embl.ebi.escience.scuflui.results.ResultTableCellCollection;
import org.embl.ebi.escience.scuflui.results.ResultThing;

public class ResultTableColumn
extends ResultTableCellCollection {
    private Collection sources = new ArrayList();
    private Collection results = new HashSet();
    protected ResultTableColumn previousColumn;
    protected ResultTableColumn nextColumn;

    public void addSource(ResultSource source) {
        System.out.println("Adding source: " + source);
        this.sources.add(source);
    }

    public int fillColumn(int startRow) {
        int currentRow = startRow;
        Iterator sourceIterator = this.sources.iterator();
        while (sourceIterator.hasNext()) {
            ResultSource source = (ResultSource)sourceIterator.next();
            Iterator resultIterator = source.results();
            while (resultIterator.hasNext()) {
                ResultThing result = (ResultThing)resultIterator.next();
                if (this.results.contains(result) || result.getDataThing().getDataObject() instanceof Collection) continue;
                ResultTableCell cell = this.createCell(this, result, currentRow);
                currentRow = cell.endRow + 1;
            }
        }
        return currentRow;
    }

    private ResultTableCell createCollection(ResultThing thing, int startRow) {
        int currentRow = startRow;
        Iterator children = thing.getDataThing().childIterator();
        ResultTableCellCollection collection = new ResultTableCellCollection();
        while (children.hasNext()) {
            DataThing child = (DataThing)children.next();
            ResultThing childResult = this.getResultThing(child.getLSID(child.getDataObject()));
            if (childResult == null) continue;
            ResultTableCell cell = this.createCell(collection, childResult, currentRow);
            currentRow = cell.endRow + 1;
        }
        ResultTableCell cell = new ResultTableCell(startRow);
        cell.endRow = currentRow - 1;
        return cell;
    }

    private ResultTableCell createCell(ResultTableCellCollection parent, ResultThing result, int startRow) {
        ResultThing previousThing;
        if (result.getDataThing().getDataObject() instanceof Collection) {
            return this.createCollection(result, startRow);
        }
        if (startRow != 0 && (previousThing = this.getValue(startRow - 1)) != null && previousThing.equals(result)) {
            ResultTableCell cell = this.getCell(startRow - 1);
            this.extendCell(cell, 1);
            System.out.println("Extended cell " + cell.startRow + "-" + cell.endRow);
            return cell;
        }
        int currentRow = startRow;
        ResultTableCell cell = new ResultTableCell(startRow);
        block0: for (int index = 0; index < result.inputLSIDs.length; ++index) {
            ResultTableColumn column = this.previousColumn;
            while (column != null) {
                ResultTableCell inputCell = column.createCell(result.inputLSIDs[index], currentRow);
                if (inputCell != null) {
                    currentRow = inputCell.endRow + 1;
                    continue block0;
                }
                column = column.previousColumn;
            }
        }
        cell.endRow = currentRow != startRow ? currentRow - 1 : startRow;
        this.add(cell, result);
        if (parent != this) {
            parent.add(cell, result);
        }
        this.results.add(result);
        return cell;
    }

    protected Collection getCellsBetween(int startRow, int endRow) {
        Iterator cellIterator = this.cells.keySet().iterator();
        ArrayList<ResultTableCell> cellList = new ArrayList<ResultTableCell>();
        while (cellIterator.hasNext()) {
            ResultTableCell cell = (ResultTableCell)cellIterator.next();
            if (!(startRow <= cell.startRow && endRow >= cell.startRow || startRow <= cell.endRow && endRow >= cell.endRow) && (cell.startRow > startRow || cell.endRow < endRow)) continue;
            cellList.add(cell);
        }
        return cellList;
    }

    private void extendCell(ResultTableCell cell, int amount) {
        Collection inputCells;
        cell.endRow += amount;
        if (this.previousColumn != null && (inputCells = this.previousColumn.getCellsBetween(cell.startRow, cell.endRow)).size() != 0) {
            int height = (cell.endRow - cell.startRow + 1) / inputCells.size();
            Iterator cellIterator = inputCells.iterator();
            while (cellIterator.hasNext()) {
                ResultTableCell inputCell = (ResultTableCell)cellIterator.next();
                int startRow = Math.max(cell.startRow, inputCell.startRow);
                int currentHeight = inputCell.endRow - startRow + 1;
                if (currentHeight >= height) continue;
                this.previousColumn.extendCell(inputCell, height - currentHeight);
            }
        }
    }

    private ResultThing getResultThing(String lsid) {
        Iterator sourceIterator = this.sources.iterator();
        while (sourceIterator.hasNext()) {
            ResultSource source = (ResultSource)sourceIterator.next();
            ResultThing thing = source.getResultThing(lsid);
            if (thing == null) continue;
            return thing;
        }
        return null;
    }

    ResultTableCell createCell(String lsid, int startRow) {
        ResultThing thing = this.getResultThing(lsid);
        if (thing != null) {
            return this.createCell(this, thing, startRow);
        }
        return null;
    }

    public String toString() {
        Iterator sourceIterator = this.sources.iterator();
        String name = null;
        while (sourceIterator.hasNext()) {
            ResultSource source = (ResultSource)sourceIterator.next();
            if (name == null) {
                name = source.toString();
                continue;
            }
            name = name + ", " + source.toString();
        }
        if (this.previousColumn == null) {
            name = "Inputs: " + name;
        }
        return name;
    }
}

