/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scuflui.results.ResultTableCell;
import org.embl.ebi.escience.scuflui.results.ResultTableColumn;
import org.embl.ebi.escience.scuflui.results.ResultTableModel;
import org.embl.ebi.escience.scuflui.results.ResultTableUI;
import org.embl.ebi.escience.scuflui.results.ResultThing;

public class ResultTable
extends JTable {
    private Collection listeners = new HashSet();
    private ResultThing selectedResult = null;
    private ResultTableCell selectedCell = null;

    public ResultTable(ScuflModel model, WorkflowInstance workflowInstance) {
        this.setModel(new ResultTableModel(model, workflowInstance));
        this.setUI(new ResultTableUI());
        this.setShowGrid(true);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setGridColor(new Color(235, 235, 235));
        this.setSelectionBackground(new Color(232, 242, 254));
        this.setSelectionForeground(Color.BLACK);
        this.setBackground(new Color(235, 235, 235));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(ResultTableCell.class, new ResultTableCellRenderer());
    }

    public void addTableSelectionListener(TableSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeTableSelectionListener(TableSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public ResultTableCell getSelectedCell() {
        return this.selectedCell;
    }

    private void fireSelectionChange() {
        ResultTableCell cell;
        if (this.getModel() instanceof ResultTableModel && (cell = this.getCell(this.getSelectedRow(), this.getSelectedColumn())) != this.selectedCell) {
            this.selectedResult = (ResultThing)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
            this.selectedCell = cell;
            Iterator listenerIterator = this.listeners.iterator();
            while (listenerIterator.hasNext()) {
                TableSelectionListener listener = (TableSelectionListener)listenerIterator.next();
                listener.valueChanged(this, this.selectedResult);
            }
        }
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        this.fireSelectionChange();
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.fireSelectionChange();
    }

    public ResultTableCell getCell(int row, int column) {
        try {
            return ((ResultTableModel)this.getModel()).getColumn(column).getCell(row);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Rectangle getCellRect(ResultTableCell cell, int column, boolean includeSpacing) {
        Rectangle rect = super.getCellRect(cell.startRow, column, includeSpacing);
        Rectangle endRect = super.getCellRect(cell.endRow, column, includeSpacing);
        rect.add(endRect);
        return rect;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        ResultTableCell cell = this.getCell(row, column);
        if (cell == null) {
            return super.getCellRect(row, column, includeSpacing);
        }
        return this.getCellRect(cell, column, includeSpacing);
    }

    private class ResultTableCellRenderer
    extends DefaultTableCellRenderer {
        private ResultTableCellRenderer() {
        }

        public boolean isOpaque() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setIcon(null);
            hasFocus = false;
            boolean listRoot = false;
            boolean listLeaf = false;
            if (value != null) {
                ResultTableCell selectedCell = ((ResultTable)table).getSelectedCell();
                ResultTableCell cell = ((ResultTable)table).getCell(row, column);
                if (cell != null) {
                    if (selectedCell != null) {
                        ResultThing selectedResult = (ResultThing)ResultTable.this.getValueAt(ResultTable.this.getSelectedRow(), ResultTable.this.getSelectedColumn());
                        boolean bl = hasFocus = value == selectedResult;
                        if (!hasFocus) {
                            for (int i = 0; i < ResultTable.this.getModel().getRowCount() && !isSelected; ++i) {
                                ResultThing currentResult = (ResultThing)ResultTable.this.getValueAt(i, ResultTable.this.getSelectedColumn());
                                if (currentResult == null || currentResult != selectedResult) continue;
                                ResultTableCell currentCell = ((ResultTable)table).getCell(i, ResultTable.this.getSelectedColumn());
                                isSelected = currentCell.startRow <= cell.startRow && currentCell.endRow >= cell.startRow || currentCell.startRow <= cell.endRow && currentCell.endRow >= cell.endRow || cell.startRow <= currentCell.startRow && cell.endRow >= currentCell.endRow;
                            }
                        }
                    }
                    if (!(cell.parent instanceof ResultTableColumn)) {
                        if (cell.parent.getCell(row - 1) == null) {
                            listRoot = true;
                        } else {
                            listLeaf = true;
                        }
                    }
                }
                this.setValue(value);
            }
            this.setFont(table.getFont());
            this.setBorder(noFocusBorder);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(table.getForeground());
                super.setBackground(Color.WHITE);
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                this.setBackground(new Color(202, 222, 254));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            }
            if (listRoot) {
                this.setIcon(UIManager.getIcon("Tree.expandedIcon"));
            } else {
                this.setIcon(null);
            }
            if (listLeaf) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 12, 0, 0, this.getBackground()), this.getBorder()));
            }
            return this;
        }
    }

    public static interface TableSelectionListener {
        public void valueChanged(ResultTable var1, ResultThing var2);
    }
}

