/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.results;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflui.results.ResultThing;

public class ResultSource {
    private int depth = -1;
    private Port sourcePort;
    private DataThing thing;
    private HashMap results = new HashMap();
    protected Collection inputs = new HashSet();
    protected Collection outputs = new HashSet();
    protected Collection outputProcessors = new HashSet();

    public ResultSource(Port sourcePort, DataThing thing) {
        this.sourcePort = sourcePort;
        this.thing = thing;
    }

    public void addInput(ResultSource thing) {
        this.inputs.add(thing);
    }

    public void addOutput(ResultSource thing) {
        this.outputs.add(thing);
    }

    public Processor getProcessor() {
        return this.sourcePort.getProcessor();
    }

    public void addOutputProcessor(Processor processor) {
        if (!processor.getName().equals("SCUFL_INTERNAL_SINKPORTS")) {
            this.outputProcessors.add(processor);
        }
    }

    public int getDepth() {
        if (this.depth == -1) {
            if (this.inputs.isEmpty()) {
                this.depth = 0;
            }
            Iterator inputIterator = this.inputs.iterator();
            while (inputIterator.hasNext()) {
                ResultSource source = (ResultSource)inputIterator.next();
                this.depth = Math.max(this.depth, source.getDepth());
            }
            ++this.depth;
        }
        return this.depth;
    }

    public ResultThing getResultThing(String lsid) {
        return (ResultThing)this.results.get(lsid);
    }

    void populateResults(HashMap provenance) {
        if (this.thing != null) {
            this.addResult(this.thing, provenance, null);
        }
    }

    private void addResult(DataThing thing, HashMap provenance, Collection inputLSIDs) {
        Collection moreInputs;
        HashSet inputList = new HashSet();
        if (inputLSIDs != null) {
            inputList.addAll(inputLSIDs);
        }
        if ((moreInputs = (Collection)provenance.get(thing.getLSID(thing.getDataObject()))) != null) {
            inputList.addAll(moreInputs);
        }
        String[] lsids = new String[inputList.size()];
        inputList.toArray(lsids);
        ResultThing result = new ResultThing(this, thing, lsids);
        this.results.put(result.getLSID(), result);
        if (thing.getDataObject() instanceof Collection) {
            Iterator childIterator = thing.childIterator();
            while (childIterator.hasNext()) {
                DataThing child = (DataThing)childIterator.next();
                this.addResult(child, provenance, inputList);
            }
        }
    }

    public String toString() {
        if (this.sourcePort.getProcessor().getName().equals("SCUFL_INTERNAL_SOURCEPORTS")) {
            return this.sourcePort.getName();
        }
        return this.sourcePort.getProcessor().getName() + ":" + this.sourcePort.getName();
    }

    public Iterator results() {
        return this.results.values().iterator();
    }
}

