/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.renderers;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.renderers.AbstractRenderer;
import org.embl.ebi.escience.scuflui.renderers.RendererException;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;

public class TextXGraphviz
extends AbstractRenderer.ByPattern {
    public TextXGraphviz() {
        super("X-Graphviz", new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/baclava/icons/text.png")), Pattern.compile(".*text/x-graphviz.*"));
    }

    protected boolean canHandle(RendererRegistry renderers, Object userObject, String mimeType) {
        return super.canHandle(renderers, userObject, mimeType) && userObject instanceof String;
    }

    public boolean isTerminal() {
        return true;
    }

    public JComponent getComponent(RendererRegistry renderers, DataThing dataThing) throws RendererException {
        String dotText = (String)dataThing.getDataObject();
        try {
            String dotLocation = System.getProperty("taverna.dotlocation");
            if (dotLocation == null) {
                dotLocation = "dot";
            }
            Process dotProcess = Runtime.getRuntime().exec(new String[]{dotLocation, "-Tpng"});
            OutputStream out = dotProcess.getOutputStream();
            out.write(dotText.getBytes());
            out.flush();
            out.close();
            InputStream in = dotProcess.getInputStream();
            ImageInputStream iis = ImageIO.createImageInputStream(in);
            String suffix = "png";
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
            ImageReader imageReader = readers.next();
            imageReader.setInput(iis, false);
            ImageIcon theImage = new ImageIcon(imageReader.read(0));
            JPanel theImagePanel = new JPanel();
            theImagePanel.add(new JLabel(theImage));
            theImagePanel.setPreferredSize(new Dimension(theImage.getIconWidth(), theImage.getIconHeight()));
            return theImagePanel;
        }
        catch (IOException ioe) {
            throw new RendererException("Could not render dot text", ioe);
        }
    }
}

