/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.renderers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;

public class RendererRegistry {
    private static Logger LOG = Logger.getLogger((Class)RendererRegistry.class);
    private static RendererRegistry instance;
    private List renderers = new ArrayList();

    public static synchronized RendererRegistry instance() {
        if (instance == null) {
            instance = new RendererRegistry();
            instance.loadInstances(RendererRegistry.class.getClassLoader());
        }
        return instance;
    }

    public void loadInstances(ClassLoader classLoader) {
        LOG.info((Object)"Loading all renderers");
        SPInterface spiIF = new SPInterface(RendererSPI.class);
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        Enumeration spe = Service.providers((SPInterface)spiIF, (ClassLoaders)loaders);
        while (spe.hasMoreElements()) {
            RendererSPI spi = (RendererSPI)spe.nextElement();
            LOG.info((Object)("\t" + spi.getName()));
            this.renderers.add(spi);
        }
        LOG.info((Object)"Done");
    }

    public RendererSPI getRenderer(DataThing dataThing) {
        LOG.info((Object)("Finding renderer: " + dataThing));
        Iterator i = this.renderers.iterator();
        while (i.hasNext()) {
            RendererSPI rend = (RendererSPI)i.next();
            if (!rend.canHandle(this, dataThing)) continue;
            LOG.info((Object)("\tFound: " + rend.getName()));
            return rend;
        }
        return null;
    }

    public List getRenderers(DataThing dataThing) {
        LOG.info((Object)("Finding renderers: " + dataThing));
        ArrayList<RendererSPI> res = new ArrayList<RendererSPI>();
        Iterator i = this.renderers.iterator();
        while (i.hasNext()) {
            RendererSPI rend = (RendererSPI)i.next();
            if (!rend.canHandle(this, dataThing)) continue;
            LOG.info((Object)("\tFound: " + rend.getName()));
            res.add(rend);
        }
        return res;
    }

    public void addRenderer(RendererSPI renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer(RendererSPI renderer) {
        this.renderers.remove(renderer);
    }

    public int size() {
        return this.renderers.size();
    }

    public Iterator iterator() {
        return this.renderers.iterator();
    }

    public RendererSPI get(int i) {
        return (RendererSPI)this.renderers.get(i);
    }
}

