/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.renderers;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;

public abstract class AbstractRenderer
implements RendererSPI {
    private String name;
    private Icon icon;

    public AbstractRenderer(String name) {
        this.name = name;
    }

    public AbstractRenderer(String name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    public final Icon getIcon(RendererRegistry renderers, DataThing dataThing) {
        return this.icon;
    }

    public final String getName() {
        return this.name;
    }

    public abstract class BySemanticType
    extends AbstractRenderer {
        protected BySemanticType(String name) {
            super(name);
        }

        protected BySemanticType(String name, Icon icon) {
            super(name, icon);
        }

        public final boolean canHandle(RendererRegistry renderers, DataThing dataThing) {
            String semanticType = dataThing.getMetadata().getSemanticType();
            Object userObject = dataThing.getDataObject();
            return this.canHandle(renderers, userObject, semanticType);
        }

        protected abstract boolean canHandle(RendererRegistry var1, Object var2, String var3);
    }

    public static abstract class ByPattern
    extends ByMimeType {
        private final Pattern pattern;

        public ByPattern(String name, Pattern pattern) {
            super(name);
            this.pattern = pattern;
        }

        public ByPattern(String name, Icon icon, Pattern pattern) {
            super(name, icon);
            this.pattern = pattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        protected boolean canHandle(RendererRegistry renderers, Object userObject, String mimeType) {
            return this.pattern.matcher(mimeType).matches();
        }

        protected String[] strip(String[] mimeTypes) {
            ArrayList<String> result = new ArrayList<String>(mimeTypes.length);
            for (int i = 0; i < mimeTypes.length; ++i) {
                String mimeType = mimeTypes[i];
                if (this.getPattern().matcher(mimeType).matches()) continue;
                result.add(mimeType);
            }
            return result.toArray(new String[result.size()]);
        }
    }

    public static abstract class ByMimeType
    extends AbstractRenderer {
        protected ByMimeType(String name) {
            super(name);
        }

        protected ByMimeType(String name, Icon icon) {
            super(name, icon);
        }

        public final boolean canHandle(RendererRegistry renderers, DataThing dataThing) {
            String[] mimeTypes = dataThing.getMetadata().getMIMETypes();
            Object userObject = dataThing.getDataObject();
            for (int i = 0; i < mimeTypes.length; ++i) {
                if (!this.canHandle(renderers, userObject, mimeTypes[i])) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean canHandle(RendererRegistry var1, Object var2, String var3);
    }
}

