/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.facets;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.embl.ebi.escience.scuflui.facets.FacetFinderSPI;

public class RegexScanner
implements FacetFinderSPI {
    private static final int PATTERN_FLAGS = 0;
    private static final DataThing EMPTY_STRING = DataThingFactory.bake("");
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner;
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$facets$PropertySheet$Editor;

    public boolean canMakeFacets(DataThing dataThing) {
        return dataThing.getDataObject() instanceof CharSequence;
    }

    public Set getStandardColumns(DataThing dataThing) {
        return Collections.EMPTY_SET;
    }

    public boolean hasColumn(FacetFinderSPI.ColumnID colID) {
        return colID instanceof Scanner;
    }

    public FacetFinderSPI.ColumnID newColumn(DataThing dataThing) {
        return new Scanner();
    }

    public DataThing getFacet(DataThing dataThing, FacetFinderSPI.ColumnID colID) {
        if (!this.hasColumn(colID) || !this.canMakeFacets(dataThing)) {
            return null;
        }
        Scanner scanner = (Scanner)colID;
        CharSequence chars = (CharSequence)dataThing.getDataObject();
        Matcher matcher = scanner.getPattern().matcher(chars);
        if (!scanner.joinValues) {
            if (scanner.makeCollection) {
                ArrayList<String> hits = new ArrayList<String>();
                while (matcher.find()) {
                    hits.add(matcher.group(scanner.getGroup()));
                }
                return DataThingFactory.bake(hits);
            }
            if (!matcher.find()) {
                return EMPTY_STRING;
            }
            return DataThingFactory.bake(matcher.group(scanner.getGroup()));
        }
        if (!matcher.find()) {
            return EMPTY_STRING;
        }
        StringBuffer res = new StringBuffer();
        res.append(matcher.group(scanner.getGroup()));
        while (matcher.find()) {
            res.append(scanner.getJoinText());
            res.append(matcher.group(scanner.getGroup()));
        }
        return DataThingFactory.bake(res.toString());
    }

    public String getName() {
        return "RegexScanner";
    }

    static {
        if (PropertyEditorManager.findEditor(Pattern.class) == null) {
            PropertyEditorManager.registerEditor(Pattern.class, PatternEditor.class);
        }
    }

    public static final class PatternEditor
    implements PropertyEditor {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private Pattern pattern;

        public void setValue(Object value) {
            Pattern oldPattern = this.pattern;
            this.pattern = (Pattern)value;
            this.pcs.firePropertyChange(null, oldPattern, this.pattern);
        }

        public Object getValue() {
            return this.pattern;
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics gfx, Rectangle box) {
        }

        public String getJavaInitializationString() {
            return "Pattern.compile(\"" + this.pattern.pattern() + "\", " + 0 + ")";
        }

        public String getAsText() {
            return this.pattern.pattern();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue(Pattern.compile(text, 0));
        }

        public String[] getTags() {
            return null;
        }

        public Component getCustomEditor() {
            return null;
        }

        public boolean supportsCustomEditor() {
            return false;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public static class Scanner
    implements FacetFinderSPI.ColumnID {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private Pattern pattern;
        private int group;
        private boolean joinValues;
        private String joinText;
        private boolean makeCollection;

        public Scanner() {
            this.pattern = Pattern.compile(".*", 0);
            this.group = 0;
            this.joinValues = false;
            this.joinText = "";
            this.makeCollection = false;
        }

        public Scanner(Pattern pattern, int group, String joinText) {
            this.pattern = pattern;
            this.group = group;
            this.joinValues = true;
            this.joinText = joinText;
            this.makeCollection = false;
        }

        public Scanner(Pattern pattern, int group, boolean makeCollection) {
            this.pattern = pattern;
            this.group = group;
            this.joinValues = false;
            this.joinText = "";
            this.makeCollection = makeCollection;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            if (pattern == null) {
                throw new NullPointerException("Can't set pattern to null");
            }
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "pattern", this.pattern, pattern);
            this.pattern = pattern;
            this.pcs.firePropertyChange(pce);
        }

        public int getGroup() {
            return this.group;
        }

        public void setGroup(int group) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "group", new Integer(this.group), new Integer(group));
            this.group = group;
            this.pcs.firePropertyChange(pce);
        }

        public boolean getJoinValues() {
            return this.joinValues;
        }

        public void setJoinValues(boolean joinValues) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "joinValues", new Boolean(this.joinValues), new Boolean(joinValues));
            this.joinValues = joinValues;
            this.pcs.firePropertyChange(pce);
        }

        public String getJoinText() {
            return this.joinText;
        }

        public void setJoinText(String joinText) {
            if (joinText == null) {
                throw new NullPointerException("Can't set join text to null. Use the empty string instead");
            }
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "joinText", this.joinText, joinText);
            this.joinText = joinText;
            this.pcs.firePropertyChange(pce);
        }

        public boolean getMakeCollection() {
            return this.makeCollection;
        }

        public void setMakeCollection(boolean makeCollection) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "makeCollection", new Boolean(this.makeCollection), new Boolean(makeCollection));
            this.makeCollection = makeCollection;
            this.pcs.firePropertyChange(pce);
        }

        public Component getCustomiser(DataThing dataThing) {
            PropertyEditor editor = PropertyEditorManager.findEditor(class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner == null ? (class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner = RegexScanner.class$("org.embl.ebi.escience.scuflui.facets.RegexScanner$Scanner")) : class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner);
            if (editor != null) {
                editor.setValue(this);
                return editor.getCustomEditor();
            }
            return null;
        }

        public String getName() {
            if (this.getPattern() == null) {
                return "Regex";
            }
            return "Regex " + this.getPattern().pattern();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Scanner)) {
                return false;
            }
            Scanner scanner = (Scanner)o;
            if (this.group != scanner.group) {
                return false;
            }
            if (this.joinValues != scanner.joinValues) {
                return false;
            }
            if (this.makeCollection != scanner.makeCollection) {
                return false;
            }
            if (!this.joinText.equals(scanner.joinText)) {
                return false;
            }
            return this.pattern.equals(scanner.pattern);
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 29 * result + this.group;
            result = 29 * result + (this.joinValues ? 1 : 0);
            result = 29 * result + this.joinText.hashCode();
            result = 29 * result + (this.makeCollection ? 1 : 0);
            return result;
        }

        static {
            PropertyEditorManager.registerEditor(class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner == null ? (class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner = RegexScanner.class$("org.embl.ebi.escience.scuflui.facets.RegexScanner$Scanner")) : class$org$embl$ebi$escience$scuflui$facets$RegexScanner$Scanner, class$org$embl$ebi$escience$scuflui$facets$PropertySheet$Editor == null ? (class$org$embl$ebi$escience$scuflui$facets$PropertySheet$Editor = RegexScanner.class$("org.embl.ebi.escience.scuflui.facets.PropertySheet$Editor")) : class$org$embl$ebi$escience$scuflui$facets$PropertySheet$Editor);
        }
    }
}

