/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui.facets;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.facets.FacetFinderSPI;

public class FacetFinderRegistry {
    private static Logger LOG = Logger.getLogger((Class)FacetFinderRegistry.class);
    private static FacetFinderRegistry instance;
    private List facetFinders = new ArrayList();

    public static synchronized FacetFinderRegistry instance() {
        if (instance == null) {
            instance = new FacetFinderRegistry();
            instance.loadInstances(FacetFinderRegistry.class.getClassLoader());
        }
        return instance;
    }

    public void loadInstances(ClassLoader classLoader) {
        LOG.info((Object)"Loading all facet finders");
        SPInterface spiIF = new SPInterface(FacetFinderSPI.class);
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        Enumeration spe = Service.providers((SPInterface)spiIF, (ClassLoaders)loaders);
        while (spe.hasMoreElements()) {
            FacetFinderSPI spi = (FacetFinderSPI)spe.nextElement();
            LOG.info((Object)("\t" + spi.getName()));
            this.facetFinders.add(spi);
        }
        LOG.info((Object)"Done");
    }

    public List getFinders(DataThing dataThing) {
        LOG.info((Object)("Finding facetisers: " + dataThing));
        ArrayList<FacetFinderSPI> res = new ArrayList<FacetFinderSPI>();
        Iterator i = this.facetFinders.iterator();
        while (i.hasNext()) {
            FacetFinderSPI finder = (FacetFinderSPI)i.next();
            LOG.info((Object)("\tfound: " + finder.getName()));
            if (!finder.canMakeFacets(dataThing)) continue;
            LOG.info((Object)("\taccepted: " + finder.getName()));
            res.add(finder);
        }
        return res;
    }

    public void addFinder(FacetFinderSPI finder) {
        this.facetFinders.add(finder);
    }

    public void removeFinder(FacetFinderSPI finder) {
        this.facetFinders.remove(finder);
    }

    public int size() {
        return this.facetFinders.size();
    }

    public Iterator iterator() {
        return this.facetFinders.iterator();
    }

    public FacetFinderSPI get(int i) {
        return (FacetFinderSPI)this.facetFinders.get(i);
    }
}

