/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class XMLTree
extends JTree {
    int textSizeLimit = 1000;

    public XMLTree(String text) throws IOException, JDOMException {
        Document document = new SAXBuilder(false).build((Reader)new StringReader(text));
        this.init((Content)document.getRootElement());
    }

    public XMLTree(Document document) {
        this.init((Content)document.getRootElement());
    }

    private void init(Content content) {
        this.setRowHeight(0);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setModel(new DefaultTreeModel(this.createTreeNode(content)));
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof XMLNode) {
                    XMLNode node = (XMLNode)value;
                    if (node.getUserObject() instanceof Element) {
                        this.setIcon(ScuflIcons.xmlNodeIcon);
                        Element element = (Element)node.getUserObject();
                        StringBuffer nameBuffer = new StringBuffer("<html>" + element.getQualifiedName());
                        boolean addedAnAttribute = false;
                        if (element.getParent() instanceof Element) {
                            Element parent = (Element)element.getParent();
                            if (parent.getNamespace(element.getNamespacePrefix()) == null) {
                                nameBuffer.append(" <font color=\"purple\">xmlns:" + element.getNamespacePrefix() + "</font>=\"<font color=\"green\">" + element.getNamespaceURI() + "</font>\"");
                            }
                        } else {
                            nameBuffer.append(" <font color=\"purple\">xmlns:" + element.getNamespacePrefix() + "</font>=\"<font color=\"green\">" + element.getNamespaceURI() + "</font>\"");
                        }
                        Iterator attributes = element.getAttributes().iterator();
                        while (attributes.hasNext()) {
                            Attribute attribute = (Attribute)attributes.next();
                            String name = attribute.getName().trim();
                            String attributeValue = attribute.getValue().trim();
                            if (attributeValue == null || attributeValue.length() <= 0) continue;
                            if (addedAnAttribute) {
                                nameBuffer.append(",");
                            }
                            addedAnAttribute = true;
                            nameBuffer.append(" <font color=\"purple\">" + name + "</font>=\"<font color=\"green\">" + attributeValue + "</font>\"");
                        }
                        nameBuffer.append("</html>");
                        this.setText(nameBuffer.toString());
                    } else if (node.getUserObject() instanceof Text) {
                        this.setIcon(ScuflIcons.leafIcon);
                        Text text = (Text)node.getUserObject();
                        String name = text.getText();
                        if (XMLTree.this.textSizeLimit > -1 && name.length() > XMLTree.this.textSizeLimit) {
                            name = name.substring(0, XMLTree.this.textSizeLimit) + "...";
                        }
                        this.setText("<html><pre><font color=\"blue\">" + name.replaceAll("<br>", "\n").replaceAll("<", "&lt;") + "</font></pre></html>");
                    }
                }
                return this;
            }
        });
        this.setAllNodesExpanded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodesExpanded() {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            this.expandAll(this, new TreePath(this.getModel().getRoot()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
    }

    public void setTextNodeSizeLimit(int sizeLimit) {
        this.textSizeLimit = sizeLimit;
    }

    private XMLNode createTreeNode(Content content) {
        XMLNode node = new XMLNode(content);
        if (content instanceof Parent) {
            Parent parent = (Parent)content;
            Iterator children = parent.getContent().iterator();
            while (children.hasNext()) {
                Text text;
                Object child = children.next();
                if (child instanceof Element) {
                    node.add(this.createTreeNode((Content)child));
                    continue;
                }
                if (this.textSizeLimit == 0 || !(child instanceof Text) || (text = (Text)child).getTextNormalize().equals("")) continue;
                node.add(this.createTreeNode((Content)text));
            }
        }
        return node;
    }

    private class XMLNode
    extends DefaultMutableTreeNode {
        public XMLNode(Content userObject) {
            super(userObject);
        }
    }
}

