/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class UIComponentRegistry {
    private static Logger log = Logger.getLogger((Class)UIComponentRegistry.class);
    private static UIComponentRegistry instance;
    private Map components = new HashMap();
    private Map icons = new HashMap();

    public static synchronized UIComponentRegistry instance() {
        if (instance == null) {
            instance = new UIComponentRegistry();
            instance.loadInstances(UIComponentRegistry.class.getClassLoader());
        }
        return instance;
    }

    public void loadInstances(ClassLoader classLoader) {
        log.info((Object)"Loading all UI components");
        SPInterface spiIF = new SPInterface(ScuflUIComponent.class);
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        Enumeration spe = Service.providers((SPInterface)spiIF, (ClassLoaders)loaders);
        while (spe.hasMoreElements()) {
            ScuflUIComponent component = (ScuflUIComponent)spe.nextElement();
            String componentClassName = component.getClass().getName();
            String componentDisplayName = component.getName();
            this.components.put(componentDisplayName, componentClassName);
            this.icons.put(componentDisplayName, component.getIcon());
        }
        log.info((Object)"Done");
    }

    public Map getComponents() {
        return this.components;
    }

    public Map getIcons() {
        return this.icons;
    }
}

